/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.fileUtil;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.dc.services.payment.batchindividualpay.fileUtil.FileHelper;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class FileHelper4Sichuan
implements FileHelper {
    EBGLogger log = EBGLogger.getInstance().getLogger(FileHelper4Sichuan.class);

    @Override
    public String packFileContent(PaymentInfo[] paymentInfos) {
        if (paymentInfos[0].is2SameBank()) {
            return this.packFileContent4SameBank(paymentInfos);
        }
        return this.packFileContent4DifBank(paymentInfos);
    }

    public String packFileContent4SameBank(PaymentInfo[] paymentInfos) {
        StringBuilder fileContentStr = new StringBuilder();
        int length = paymentInfos.length;
        for (int i = 0; i < length; ++i) {
            PaymentInfo payInfo = paymentInfos[i];
            fileContentStr.append(i).append("|");
            fileContentStr.append(payInfo.getIncomeAccNo()).append("|");
            fileContentStr.append(payInfo.getIncomeAccName()).append("|");
            fileContentStr.append(payInfo.getAmount()).append("|");
            fileContentStr.append(payInfo.getExplanation()).append("|");
            fileContentStr.append(payInfo.getId()).append("\n");
        }
        return fileContentStr.toString();
    }

    public String packFileContent4DifBank(PaymentInfo[] paymentInfos) {
        StringBuilder fileContentStr = new StringBuilder();
        int length = paymentInfos.length;
        for (int i = 0; i < length; ++i) {
            PaymentInfo payInfo = paymentInfos[i];
            fileContentStr.append(i).append("|");
            fileContentStr.append(payInfo.getIncomeAccNo()).append("|");
            fileContentStr.append(payInfo.getIncomeAccName()).append("|");
            fileContentStr.append(payInfo.getAmount()).append("|");
            fileContentStr.append(payInfo.getExplanation()).append("|");
            fileContentStr.append(payInfo.getIncomeCnaps()).append("|");
            fileContentStr.append(payInfo.getId()).append("\n");
        }
        return fileContentStr.toString();
    }

    @Override
    public Map parseFileContent(String fileContent) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)fileContent)) {
            String[] rows = fileContent.split("\n");
            boolean isSameBank = rows[0].split("\\|", -1).length == 9;
            String successState = isSameBank ? ResManager.loadKDString((String)"\u6210\u529f", (String)"FileHelper4Sichuan_0", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d7\u7406", (String)"FileHelper4Sichuan_1", (String)"ebg-aqap-banks-ccb-dc", (Object[])new Object[0]);
            for (String row : rows) {
                String[] cols = row.split("\\|", -1);
                int colsLength = cols.length;
                if (colsLength >= 9) {
                    String seqId = cols[colsLength - 4];
                    if (successState.equalsIgnoreCase(cols[colsLength - 3])) {
                        resultMap.put(seqId, "SUCCESS");
                        continue;
                    }
                    resultMap.put(seqId, cols[colsLength - 2]);
                    continue;
                }
                this.log.info("\u89e3\u6790\u4ee3\u53d1\u6587\u4ef6\u660e\u7ec6\u6570\u636e\u5f02\u5e38\uff0c\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e:" + row);
            }
        }
        return resultMap;
    }

    @Override
    public String genKey(PaymentInfo info) {
        return info.getId();
    }
}

