/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sjb.cms.services.detail;

import java.time.format.DateTimeFormatter;
import kd.ebg.aqap.banks.sjb.cms.utils.TCommon;
import kd.ebg.aqap.banks.sjb.cms.utils.TPacker;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailPacker.class);

    public static String packTodayDetail(BankDetailRequest req, String pageTag) throws EBServiceException {
        BankAcnt acnt = req.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "200110";
        Element ap = TPacker.createCommonHead(tr_code, req_no);
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)req.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)req.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)req.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return TCommon.createCommonMsg(xmlMsg);
    }

    public static String packHisDetail(BankDetailRequest req, String pageTag) throws EBServiceException {
        return DetailPacker.packTodayDetail(req, pageTag);
    }
}

