/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.sdk.ebg.cus.api.ISDKBankBusiness;
import kd.sdk.ebg.cus.api.ISDKBankMetaData;
import kd.sdk.ebg.cus.api.ISDKBankSeqID;

public class CUSMetaDataCache {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CUSMetaDataCache.class);
    private static Map<String, ISDKBankMetaData> bankMetaDataMap = new HashMap<String, ISDKBankMetaData>(1);
    private static Map<String, ISDKBankBusiness> bankBusinessMap = new HashMap<String, ISDKBankBusiness>(1);
    private static Map<String, ISDKBankSeqID> bankSeqIDMap = new HashMap<String, ISDKBankSeqID>(1);
    private static boolean init;
    private static CUSMetaDataCache instance;

    public static CUSMetaDataCache getInstance() {
        return instance;
    }

    private void initBankMetaData() {
        Set<Class<?>> clzImplSet = ReflectUtil.getSubTypesOf(ISDKBankMetaData.class);
        if (clzImplSet != null) {
            for (Class<?> c : clzImplSet) {
                try {
                    ISDKBankMetaData bankMetaData = (ISDKBankMetaData)c.newInstance();
                    bankMetaDataMap.put(bankMetaData.getBankVersionID(), bankMetaData);
                }
                catch (Throwable t) {
                    String msg = ResManager.loadKDString((String)"\u5b9a\u5236\u5316\u5f00\u53d1\u94f6\u884c\u63d2\u4ef6\u63cf\u8ff0\u4fe1\u606f\u52a0\u8f7d\u5f02\u5e38\u3002", (String)"CUSMetaDataCache_1", (String)"ebg-aqap-common", (Object[])new Object[0]);
                    this.logger.monitorError(msg, t);
                }
            }
        }
    }

    private void initBankBusiness() {
        Set<Class<?>> clzImplSet = ReflectUtil.getSubTypesOf(ISDKBankBusiness.class);
        if (clzImplSet != null) {
            for (Class<?> c : clzImplSet) {
                try {
                    ISDKBankBusiness bankBusiness = (ISDKBankBusiness)c.newInstance();
                    bankBusinessMap.put(bankBusiness.getBankVersionID(), bankBusiness);
                }
                catch (Throwable t) {
                    String msg = ResManager.loadKDString((String)"\u5b9a\u5236\u5316\u5f00\u53d1\u94f6\u884c\u4e1a\u52a1\u914d\u7f6e\u9879\u52a0\u8f7d\u5f02\u5e38\u3002", (String)"CUSMetaDataCache_2", (String)"ebg-aqap-common", (Object[])new Object[0]);
                    this.logger.monitorError(msg, t);
                }
            }
        }
    }

    private void initBankSeqID() {
        Set<Class<?>> clzImplSet = ReflectUtil.getSubTypesOf(ISDKBankSeqID.class);
        if (clzImplSet != null) {
            for (Class<?> c : clzImplSet) {
                try {
                    ISDKBankSeqID bankSeqID = (ISDKBankSeqID)c.newInstance();
                    bankSeqIDMap.put(bankSeqID.getBankVersionID(), bankSeqID);
                }
                catch (Throwable t) {
                    String msg = ResManager.loadKDString((String)"\u5b9a\u5236\u5316\u5f00\u53d1\u94f6\u884c\u6d41\u6c34\u53f7\u751f\u6210\u5668\u52a0\u8f7d\u5f02\u5e38\u3002", (String)"CUSMetaDataCache_3", (String)"ebg-aqap-common", (Object[])new Object[0]);
                    this.logger.monitorError(msg, t);
                }
            }
        }
    }

    public Map<String, ISDKBankMetaData> getCUSMetaDataSet() {
        if (!init) {
            this.initBankMetaData();
            this.initBankBusiness();
            this.initBankSeqID();
            init = true;
        }
        return bankMetaDataMap;
    }

    public ISDKBankMetaData getCUSMetaDataImpl(String bankVersion) {
        if (bankMetaDataMap.containsKey(bankVersion)) {
            return bankMetaDataMap.get(bankVersion);
        }
        return null;
    }

    public ISDKBankBusiness getCUSBankBusiness(String bankVersion) {
        if (bankBusinessMap.containsKey(bankVersion)) {
            return bankBusinessMap.get(bankVersion);
        }
        return null;
    }

    public ISDKBankSeqID getCUSBankSeqID(String bankVersion) {
        if (bankSeqIDMap.containsKey(bankVersion)) {
            return bankSeqIDMap.get(bankVersion);
        }
        return null;
    }

    static {
        instance = new CUSMetaDataCache();
    }
}

