/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.reconciliation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.common.framework.bank.meta.rule.BankReqLenRule;
import kd.ebg.aqap.common.framework.reconciliation.IKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.KDProcessorEnum;
import kd.ebg.aqap.common.framework.reconciliation.KDRule;
import kd.ebg.aqap.common.framework.reconciliation.processor.FileKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.processor.JsonKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.processor.XMLDataDomainKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.processor.XmlKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.rule.BankRuleCache;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.BankInterfaceRepository;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class KDProcessorFactory {
    EBGLogger logger = EBGLogger.getInstance().getLogger(KDProcessorFactory.class);
    private static KDProcessorFactory instance;

    public static synchronized KDProcessorFactory getInstance() {
        if (instance == null) {
            instance = new KDProcessorFactory();
        }
        return instance;
    }

    private Optional<IKDProcessor> getKDProcess(KDRule rule) {
        String name = rule.getContentType();
        if (KDProcessorEnum.XML_KD_PROCESSOR.getName().equalsIgnoreCase(name)) {
            return Optional.of(new XmlKDProcessor());
        }
        if (KDProcessorEnum.JSON_KD_PROCESSOR.getName().equalsIgnoreCase(name)) {
            return Optional.of(new JsonKDProcessor());
        }
        if (KDProcessorEnum.FILE_KD_PROCESSOR.getName().equalsIgnoreCase(name)) {
            return Optional.of(new FileKDProcessor());
        }
        if (KDProcessorEnum.XML_DATA_DOMAIN_KD_PROCESSOR.getName().equalsIgnoreCase(name)) {
            return Optional.of(new XMLDataDomainKDProcessor(rule.getRecordNum(), rule.isSkipFirstLine()));
        }
        return Optional.empty();
    }

    public String processPaymentInfoAndRepack(String content, List<PaymentInfo> paymentInfoList) {
        String bankVersion = EBContext.getContext().getBankVersionID();
        String className = paymentInfoList.get(0).getImplClassName();
        String interfaceCode = BankInterfaceRepository.getInstance().getBankInterfaceCode(className, bankVersion);
        if (StringUtils.isEmpty((String)interfaceCode)) {
            this.logger.warn("\u94f6\u884c\u63a5\u53e3\u5217\u8868\u672a\u627e\u5230\u94f6\u884c\u63a5\u53e3\u4ee3\u7801\uff0c\u8df3\u8fc7\u4ed8\u6b3eKD\u5bf9\u8d26\u7801\u89c4\u5219\u68c0\u67e5\u3002");
            return content;
        }
        List<KDRule> rules = this.getKDRule(interfaceCode, bankVersion);
        if (rules.size() == 0) {
            this.logger.warn("\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u8d26\u7801\u89c4\u5219\u3002");
        }
        for (KDRule rule : rules) {
            Optional<IKDProcessor> optionalIKDProcessor = this.getKDProcess(rule);
            if (!optionalIKDProcessor.isPresent()) continue;
            IKDProcessor processor = optionalIKDProcessor.get();
            content = processor.processPay(content, paymentInfoList, rule);
        }
        BankReqLenRule bankReqLenRule = BankRuleCache.getInstance().getBankReqLenRule(bankVersion);
        if (bankReqLenRule.isEnable()) {
            return bankReqLenRule.formatLen(content);
        }
        return content;
    }

    public void processDetailInfo(String content, List<DetailInfo> detailInfoList) {
        String bankVersion = EBContext.getContext().getBankVersionID();
        String className = (String)EBContext.getContext().getRunningParams().get("detail_impl");
        if (StringUtils.isEmpty((String)className)) {
            this.logger.warn("\u4e1a\u52a1\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728\u4ea4\u6613\u660e\u7ec6\u5b9e\u73b0\u7c7b\uff0c\u8df3\u8fc7\u4ed8\u6b3eKD\u5bf9\u8d26\u7801\u89c4\u5219\u68c0\u67e5\u3002");
        } else {
            String interfaceCode = BankInterfaceRepository.getInstance().getBankInterfaceCode(className, bankVersion);
            if (!StringUtils.isEmpty((String)interfaceCode)) {
                List<KDRule> rules = this.getKDRule(interfaceCode, bankVersion);
                rules.addAll(this.getKDHistoryRule(interfaceCode, bankVersion));
                if (rules.size() == 0) {
                    this.logger.warn("\u6ca1\u6709\u67e5\u8be2\u5230\u5bf9\u8d26\u7801\u89c4\u5219\u3002");
                }
                for (KDRule rule : rules) {
                    Optional<IKDProcessor> optionalIKDProcessor = this.getKDProcess(rule);
                    if (!optionalIKDProcessor.isPresent()) continue;
                    IKDProcessor processor = optionalIKDProcessor.get();
                    processor.processDetail(content, detailInfoList, rule);
                }
            } else {
                this.logger.warn("\u94f6\u884c\u63a5\u53e3\u5217\u8868\u672a\u627e\u5230\u94f6\u884c\u63a5\u53e3\u4ee3\u7801\uff0c\u8df3\u8fc7\u4ed8\u6b3eKD\u5bf9\u8d26\u7801\u89c4\u5219\u68c0\u67e5\u3002");
            }
        }
    }

    private List<KDRule> getKDRule(String interfaceCode, String bankVersion) {
        return this.getKDRule(interfaceCode, bankVersion, false);
    }

    private List<KDRule> getKDHistoryRule(String interfaceCode, String bankVersion) {
        return this.getKDRule(interfaceCode, bankVersion, true);
    }

    private List<KDRule> getKDRule(String interfaceCode, String bankVersion, boolean isHistory) {
        ArrayList<KDRule> kdRuleList = new ArrayList<KDRule>(1);
        String entityName = "aqap_reconciliation_rule";
        if (isHistory) {
            entityName = "aqap_rc_history_rule";
        }
        QFilter qFilter = QFilter.of((String)"interface_code.bank_code=? and group.number=? and state='1'", (Object[])new Object[]{interfaceCode, bankVersion});
        Map map = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qFilter.toArray());
        for (Map.Entry entry : map.entrySet()) {
            KDRule rule = new KDRule();
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            String bizType = dynamicObject.getString("biz_type");
            String contentType = dynamicObject.getString("content_type");
            String separator = KDProcessorEnum.getKDRuleSeparator(contentType);
            int explanationSize = dynamicObject.getInt("bank_field_size");
            StringBuilder sb = new StringBuilder();
            sb.append(dynamicObject.getString("node_path")).append(separator).append(dynamicObject.getString("node_name"));
            String kdFlag = dynamicObject.getString("kd_flag");
            int kdSize = dynamicObject.getInt("kd_size");
            boolean isMerge = dynamicObject.getBoolean("is_merge");
            boolean isBankRef = dynamicObject.getBoolean("is_bank_ref");
            boolean isSkipFirstRow = dynamicObject.getBoolean("is_skip_first_row");
            int recordNum = dynamicObject.getInt("record_num");
            rule.setBankVersion(bankVersion);
            rule.setInterfaceCode(interfaceCode);
            rule.setBizType(bizType);
            rule.setContentType(contentType);
            rule.setNodePath(sb.toString());
            rule.setKdFlag(kdFlag);
            rule.setKdFlagIDLength(kdSize);
            rule.setExplanationSize(explanationSize);
            rule.setMergeFlag(isMerge);
            rule.setBankRefFlag(isBankRef);
            rule.setSkipFirstLine(isSkipFirstRow);
            rule.setRecordNum(recordNum);
            kdRuleList.add(rule);
        }
        return kdRuleList;
    }
}

