/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.reconciliation.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import kd.ebg.aqap.common.framework.reconciliation.AbstractKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.find.FindNodeInfo;
import kd.ebg.egf.common.utils.string.StringUtils;

public class XmlKDProcessor
extends AbstractKDProcessor {
    @Override
    public List<FindNodeInfo> handle(String content, String nodePath) {
        Stack<FindNodeInfo> nodeInfoStack = new Stack<FindNodeInfo>();
        ArrayList<FindNodeInfo> nodeInfoList = new ArrayList<FindNodeInfo>(16);
        LinkedHashMap<String, String> nodePathMap = new LinkedHashMap<String, String>(16);
        if (StringUtils.isNotEmpty((String)nodePath)) {
            String[] nodes;
            if (nodePath.startsWith("/")) {
                nodePath = nodePath.substring(1);
            }
            for (String node : nodes = nodePath.split("/")) {
                nodePathMap.put(node, node);
            }
            int j = -1;
            block1: for (int i = j + 1; i < content.length(); ++i) {
                FindNodeInfo nodeInfo;
                if (content.charAt(i) == '<' && i < content.length() - 1 && content.charAt(i + 1) != '/' && content.charAt(i + 1) != '?') {
                    for (j = i + 1; j < content.length(); ++j) {
                        if (content.charAt(j) != '>') continue;
                        String tempNodeName = this.getTempNodeName(content.substring(i + 1, j));
                        if (!nodePathMap.containsKey(tempNodeName)) continue block1;
                        nodeInfo = new FindNodeInfo();
                        nodeInfo.setNodeName(tempNodeName);
                        nodeInfo.setStartIndex(j + 1);
                        nodeInfoStack.push(nodeInfo);
                        continue block1;
                    }
                    continue;
                }
                if (content.charAt(i) != '<' || i >= content.length() - 1 || content.charAt(i + 1) != '/') continue;
                for (j = i + 1; j < content.length(); ++j) {
                    if (content.charAt(j) != '>') continue;
                    String tempNodeName = this.getTempNodeName(content.substring(i + 2, j));
                    if (nodeInfoStack.empty() || !((FindNodeInfo)nodeInfoStack.peek()).getNodeName().equalsIgnoreCase(tempNodeName)) continue block1;
                    if (this.isMatch(nodeInfoStack, nodePath)) {
                        nodeInfo = nodeInfoStack.pop();
                        nodeInfo.setEndIndex(i);
                        String value = content.substring(nodeInfo.getStartIndex(), nodeInfo.getEndIndex());
                        nodeInfo.setNodeValue(value);
                        nodeInfoList.add(nodeInfo);
                        continue block1;
                    }
                    nodeInfoStack.pop();
                    continue block1;
                }
            }
        }
        return nodeInfoList;
    }

    private boolean isMatch(Stack<FindNodeInfo> stack, String pattern) {
        StringBuilder sb = new StringBuilder();
        Iterator infoIterator = stack.iterator();
        while (infoIterator.hasNext()) {
            sb.append(((FindNodeInfo)infoIterator.next()).getNodeName()).append('/');
        }
        String compareStr = sb.toString();
        if (compareStr.endsWith("/")) {
            compareStr = compareStr.substring(0, compareStr.length() - 1);
        }
        return pattern.equals(compareStr);
    }

    private String getTempNodeName(String tempNodeName) {
        int index = tempNodeName.indexOf(" ");
        if (index != -1) {
            tempNodeName = tempNodeName.substring(0, index);
        }
        return tempNodeName;
    }
}

