/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.reconciliation.rule;

import java.util.HashMap;
import java.util.Map;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.rule.BankReqLenRule;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;

public class BankRuleCache {
    private static BankRuleCache instance = new BankRuleCache();
    private Map<String, BankReqLenRule> reqLenRuleMap = new HashMap<String, BankReqLenRule>(1);

    public static BankRuleCache getInstance() {
        return instance;
    }

    public BankReqLenRule getBankReqLenRule(String bankVersion) {
        if (this.reqLenRuleMap.containsKey(bankVersion)) {
            return this.reqLenRuleMap.get(bankVersion);
        }
        BankMetaDataCollector meta = BankBundleManager.getInstance().getBankMetaDataCollector(bankVersion);
        if (meta != null) {
            BankReqLenRule rule = meta.getBankReqLenRule();
            if (rule != null) {
                this.reqLenRuleMap.put(bankVersion, rule);
            }
            return rule;
        }
        return new BankReqLenRule(false);
    }
}

