/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.task;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.repository.monitor.BankReqRecordRepository;
import org.slf4j.MDC;

public class BLoginMonitorStatisticTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BLoginMonitorStatisticTask.class);
    private static Map<String, String> DateClearMap = new HashMap<String, String>(1);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        String customID = requestContext.getTenantId();
        String accountId = RequestContext.get().getAccountId();
        BankReqRecordRepository bankReqRecordRepository = SpringContextUtil.getBean(BankReqRecordRepository.class);
        this.logger.info("\u524d\u7f6e\u673a\u76d1\u63a7\u8c03\u5ea6\u5f00\u59cb\u6267\u884c");
        try {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime start = this.getStartTime(now);
            Map infoMap = bankReqRecordRepository.getStatisticMapByCustomID(customID, start, now);
            for (Map.Entry mapEntry : infoMap.entrySet()) {
                String loginID = (String)mapEntry.getKey();
                this.logger.info("-------------------------------------");
                this.logger.info("\u524d\u7f6e\u673a{}\u4e1a\u52a1\u8bf7\u6c42\u7edf\u8ba1:", (Object)loginID);
                String key = this.getCacheKey(customID, loginID);
                this.logger.info("\u76d1\u63a7\u6570\u636e{}\u8fdb\u884c\u7f13\u5b58", (Object)key);
            }
        }
        catch (Exception e) {
            this.logger.error("\u524d\u7f6e\u673a\u76d1\u63a7\u8c03\u5ea6\u6355\u83b7\u5f02\u5e38\u4fe1\u606f\uff0c" + e.getMessage(), (Throwable)e);
        }
        this.logger.info("\u524d\u7f6e\u673a\u76d1\u63a7\u8c03\u5ea6\u6267\u884c\u5b8c\u6bd5");
        String date = LocalDate.now().format(DateTimeFormatter.ISO_DATE);
        String key = customID + "_" + accountId + "_" + date;
        if (!DateClearMap.containsKey(key)) {
            DateClearMap.clear();
            DateClearMap.put(key, "false");
        }
        if (!Boolean.parseBoolean(DateClearMap.get(key))) {
            bankReqRecordRepository.clearHistory();
            DateClearMap.put(key, "true");
        }
    }

    private String getCacheKey(String customID, String bankLoginID) {
        StringBuilder sb = new StringBuilder();
        sb.append("eb_login_monitor_").append(customID).append('_').append(bankLoginID);
        return sb.toString();
    }

    private LocalDateTime getStartTime(LocalDateTime now) {
        int year = now.getYear();
        int month = now.getMonthValue();
        int dayOfMonth = now.getDayOfMonth();
        return LocalDateTime.of(year, month, dayOfMonth, 0, 0, 0);
    }
}

