/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.login.utils.sms.impl.KDSMSSender;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;
import kd.ebg.aqap.common.model.repository.AlertMessageRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import org.slf4j.MDC;

public class CACertAlertTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CACertAlertTask.class);
    private final String AUTH_ENTITY = "aqap_bd_cert";
    private final String signature = ResManager.loadKDString((String)"\u91d1\u8776\u94f6\u4f01\u4e91", (String)"CACertAlertTask_0", (String)"ebg-aqap-common", (Object[])new Object[0]);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        AlertMessageRepository alertMessageRepository = SpringContextUtil.getBean(AlertMessageRepository.class);
        this.logger.info("\u8bc1\u4e66\u9884\u8b66\u68c0\u67e5\u5f00\u542f");
        Date now = new Date();
        Date endDate = DateUtil.getNextDay((Date)now, (int)60);
        QFilter filter = QFilter.of((String)"custom_id=? and is_alert=? and expire_time >= ? and expire_time <= ? and mobiles != ''", (Object[])new Object[]{RequestContext.get().getTenantId(), "true", now, endDate});
        String selectProps = "file_name, bank_config_name, expire_time, custom_id, alert_day, is_alert, mobiles, cert_type";
        DynamicObjectCollection collections = QueryServiceHelper.query((String)"aqap_bd_cert", (String)selectProps, (QFilter[])filter.toArray());
        if (collections != null) {
            boolean hasSender = false;
            for (DynamicObject dynamicObject : collections) {
                int alertDay;
                Date alertDate;
                Date expireTime = dynamicObject.getDate("expire_time");
                if (expireTime == null || !DateUtil.isBefore((Date)expireTime, (Date)(alertDate = DateUtil.getNextDay((Date)now, (int)(alertDay = dynamicObject.getInt("alert_day")))))) continue;
                String mobiles = dynamicObject.getString("mobiles");
                StringBuilder message = new StringBuilder();
                message.append(CertTypeEnum.getNameByType(dynamicObject.getInt("cert_type"))).append("\u201c").append(dynamicObject.getString("bank_config_name")).append("\u201d").append(dynamicObject.getString("file_name")).append(ResManager.loadKDString((String)"\u5373\u5c06\u8fc7\u671f\uff0c\u8fc7\u671f\u65f6\u95f4\u4e3a\u3002", (String)"CACertAlertTask_1", (String)"ebg-aqap-common", (Object[])new Object[0])).append(DateUtil.formatDate((Date)expireTime, (String)"yyyy-MM-dd")).append('\uff0c').append(ResManager.loadKDString((String)"\u8bf7\u53ca\u65f6\u66f4\u6362\u8bc1\u4e66\u3002", (String)"CACertAlertTask_2", (String)"ebg-aqap-common", (Object[])new Object[0]));
                KDSMSSender sender = new KDSMSSender();
                boolean result = sender.sendMessage(mobiles, message.toString(), this.signature);
                StringBuilder myMsg = new StringBuilder();
                myMsg.append('\u3010').append(this.signature).append('\u3011').append((CharSequence)message);
                alertMessageRepository.save("1", CosmicConstants.ALERT_TYPE_MOBILE, mobiles, new Date(), myMsg.toString(), String.valueOf(result));
                this.logger.info("\u53d1\u9001\u8bc1\u4e66\u9884\u8b66\u4fe1\u606f\uff0c\u624b\u673a\u53f7\uff1a{}\uff0c\u77ed\u4fe1\u5185\u5bb9\uff1a{}", new Object[]{mobiles, myMsg.toString()});
                hasSender = true;
            }
            if (!hasSender) {
                this.logger.info("\u6682\u65e0\u9884\u8b66\u671f\u5185\u8fc7\u671f\u8bc1\u4e66\u8bb0\u5f55");
            }
        } else {
            this.logger.info("\u6682\u65e0\u9884\u8b66\u671f\u5185\u8fc7\u671f\u8bc1\u4e66\u8bb0\u5f55");
        }
        this.logger.info("\u8bc1\u4e66\u9884\u8b66\u68c0\u67e5\u5b8c\u6210");
    }
}

