/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.utils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ebg.aqap.common.core.security.Signer;
import kd.ebg.aqap.common.model.PaymentHash;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.PaymentHashRepository;
import kd.ebg.aqap.common.security.utils.PaySignature;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;

@Component
public class PaymentSigner
implements Signer<PaymentInfo> {
    EBGLogger log = EBGLogger.getInstance().getLogger(PaymentSigner.class);
    private final PaymentHashRepository paymentHashRepository;

    public PaymentSigner(PaymentHashRepository paymentHashRepository) {
        this.paymentHashRepository = paymentHashRepository;
    }

    @Override
    public String sign(PaymentInfo toSignObj) {
        if (Objects.isNull(toSignObj)) {
            return "";
        }
        BigDecimal actualAmount = toSignObj.getActualAmount();
        if (actualAmount == null) {
            actualAmount = BigDecimal.valueOf(0.0).setScale(2);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(toSignObj.getId()).append(toSignObj.getAccNo()).append(toSignObj.getAccName()).append(toSignObj.getIncomeAccNo()).append(toSignObj.getIncomeAccName()).append(toSignObj.getAmount()).append(actualAmount).append(toSignObj.getBatchSeqID()).append(toSignObj.getDetailSeqID());
        return PaySignature.getInstance().sign(sb.toString());
    }

    @Override
    public String signAndSave(PaymentInfo toSignObj) {
        String dataHash = this.sign(toSignObj);
        PaymentHash paymentHash = new PaymentHash();
        paymentHash.setId(toSignObj.getId());
        paymentHash.setDetailSeqID(toSignObj.getDetailSeqID());
        paymentHash.setBankDetailSeqID(toSignObj.getBankDetailSeqID());
        paymentHash.setDataHash(dataHash);
        paymentHash.setCreateTime(LocalDateTime.now());
        paymentHash.setCustomID(EBContext.getContext().getCustomID());
        this.paymentHashRepository.save(paymentHash);
        return dataHash;
    }

    @Override
    public void signAndInsert(List<PaymentInfo> paymentInfoList) {
        ArrayList<PaymentHash> paymentHashList = new ArrayList<PaymentHash>(16);
        for (PaymentInfo paymentInfo : paymentInfoList) {
            String dataHash = this.sign(paymentInfo);
            PaymentHash paymentHash = new PaymentHash();
            paymentHash.setId(paymentInfo.getId());
            paymentHash.setDetailSeqID(paymentInfo.getDetailSeqID());
            paymentHash.setBankDetailSeqID(paymentInfo.getBankDetailSeqID());
            paymentHash.setDataHash(dataHash);
            paymentHash.setCreateTime(LocalDateTime.now());
            paymentHash.setCustomID(EBContext.getContext().getCustomID());
            paymentHashList.add(paymentHash);
        }
        this.paymentHashRepository.insert(paymentHashList);
        this.log.info("\u4ed8\u6b3e\u7b7e\u540d\u63d2\u5165\u5b8c\u6210");
    }

    @Override
    public boolean validate(PaymentInfo toValidateObj) {
        PaymentHash hash = this.getHash(toValidateObj);
        if (Objects.isNull(hash)) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        BigDecimal actualAmount = toValidateObj.getActualAmount();
        if (actualAmount == null) {
            actualAmount = BigDecimal.valueOf(0.0).setScale(2);
        }
        sb.append(toValidateObj.getId()).append(toValidateObj.getAccNo()).append(toValidateObj.getAccName()).append(toValidateObj.getIncomeAccNo()).append(toValidateObj.getIncomeAccName()).append(toValidateObj.getAmount()).append(actualAmount).append(toValidateObj.getBatchSeqID()).append(toValidateObj.getDetailSeqID());
        return PaySignature.getInstance().verify(hash.getDataHash(), sb.toString());
    }

    private PaymentHash getHash(PaymentInfo toValidateObj) {
        if (Objects.isNull(toValidateObj)) {
            return null;
        }
        String detailSeqID = toValidateObj.getDetailSeqID();
        PaymentHash hash = this.paymentHashRepository.findByDetailSeqID(detailSeqID);
        return hash;
    }

    @Override
    public boolean validateStrict(PaymentInfo toValidateObj) {
        return false;
    }

    public boolean validate(PaymentInfo toValidateObj, String hash) {
        if (hash == null || hash.length() == 0) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        BigDecimal actualAmount = toValidateObj.getActualAmount();
        if (actualAmount == null) {
            actualAmount = BigDecimal.valueOf(0.0).setScale(2);
        }
        sb.append(toValidateObj.getId()).append(toValidateObj.getAccNo()).append(toValidateObj.getAccName()).append(toValidateObj.getIncomeAccNo()).append(toValidateObj.getIncomeAccName()).append(toValidateObj.getAmount()).append(actualAmount).append(toValidateObj.getBatchSeqID()).append(toValidateObj.getDetailSeqID());
        return PaySignature.getInstance().verify(hash, sb.toString());
    }

    public Map<String, String> getPaymentHash(List<PaymentInfo> paymentInfos) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        ArrayList<String> detailSeqIDList = new ArrayList<String>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            detailSeqIDList.add(paymentInfo.getDetailSeqID());
        }
        if (detailSeqIDList != null && detailSeqIDList.size() > 0) {
            result.putAll(this.paymentHashRepository.findByDetailSeqIDList(detailSeqIDList));
        }
        return result;
    }
}

