/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.utils;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;

public class XlsUtlis {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(XlsUtlis.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> analysisXlsFile(String filePath, String[] rowNameArray, String sheetName, boolean isSkipFirstLine) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(1);
        HSSFWorkbook workbook = null;
        InputStream inputStream = null;
        try {
            inputStream = Resources.getResource((String)filePath).openStream();
            workbook = new HSSFWorkbook(inputStream);
            HSSFSheet sheet = workbook.getSheet(sheetName);
            int lastRowNum = sheet.getLastRowNum();
            int startLine = 0;
            if (isSkipFirstLine) {
                startLine = 1;
            }
            logger.info("xls\u89e3\u6790-\u6587\u4ef6\u540d\uff1a{}-\u603b\u884c\u6570\uff1a{}", new Object[]{filePath, lastRowNum});
            for (int i = startLine; i <= lastRowNum; ++i) {
                HSSFRow row = sheet.getRow(i);
                HashMap<String, String> paramMap = new HashMap<String, String>(rowNameArray.length);
                for (int j = 0; j < rowNameArray.length; ++j) {
                    String value = "";
                    HSSFCell cell = row.getCell(j);
                    if (cell == null) {
                        paramMap.put(rowNameArray[j], value);
                        continue;
                    }
                    CellType cellType = cell.getCellType();
                    if (cellType.equals((Object)CellType.STRING)) {
                        value = cell.getStringCellValue();
                    }
                    if (cellType.equals((Object)CellType.NUMERIC)) {
                        value = Math.round(cell.getNumericCellValue()) + "";
                    }
                    if (cellType.equals((Object)CellType.BOOLEAN)) {
                        value = Boolean.toString(cell.getBooleanCellValue());
                    }
                    paramMap.put(rowNameArray[j], value);
                }
                resultList.add(paramMap);
            }
        }
        catch (IOException e) {
            logger.error("xls\u89e3\u6790\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (IOException e) {
                            logger.error("\u8bfb\u53d6xls\u6587\u4ef6-io\u5173\u95ed\u5f02\u5e38\uff1a" + e.getMessage());
                        }
                    }
                }
                catch (IOException e) {
                    logger.error("io\u5173\u95ed\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
        return resultList;
    }
}

