/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.ZoneId;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.CipherCertUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class CertRepository {
    private String ENTITY_NAME = "aqap_bd_cert";
    private String selectProperties = "id, bank_config_id, bank_config_value_tag, bank_config_name, bank_login_id, bank_version_id, type, cert_type, custom_id, file_name, expire_time, is_alert, alert_day, cert_password, cert_source, acnt_no, download_path, source";

    public CertInfo findPlateFormCertByBankVersionIDAndBankConfigID(String bankVersionID, String bankConfigId) {
        String selectProperties = "id, bank_config_id, bank_config_value_tag, custom_id, cert_password";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.ENTITY_NAME, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_version_id", "=", (Object)bankVersionID), new QFilter("bank_config_id", "=", (Object)bankConfigId), new QFilter("type", "=", (Object)CertType.PLATEFORM_CER.getType())});
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
            Long id = dynamicObject.getLong("id");
            CertInfo certInfo = new CertInfo();
            certInfo.setCertID(String.valueOf(id));
            certInfo.setFileContent(dynamicObject.getString("bank_config_value_tag"));
            certInfo.setCertPassword(CipherCertUtil.desEncrypt((String)dynamicObject.getString("cert_password"), (Long)id));
            certInfo.setCustomID(dynamicObject.getString("custom_id"));
            return certInfo;
        }
        return null;
    }

    public DynamicObject[] loadByCustomID(String customID) {
        QFilter filter = QFilter.of((String)"custom_id = ?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)"id, custom_id,bank_config_value_tag", (QFilter[])filter.toArray());
        return dynamicObjects;
    }

    public DynamicObject[] loadCertByType(String certType) {
        return BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)certType)});
    }

    public DynamicObject[] loadCertByTypeAndBankVersion(String certType, String bankVersionID) {
        return BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])new QFilter[]{new QFilter("bank_version_id", "=", (Object)bankVersionID), new QFilter("type", "=", (Object)certType)});
    }

    public DynamicObject[] loadCertByAcnt(String accno) {
        return BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])new QFilter[]{new QFilter("acnt_no", "=", (Object)accno), new QFilter("type", "=", (Object)CertType.ACNT_CER)});
    }

    public void updateCert(DynamicObject cerData, String key, String name, String bankVersionID, CertInfo certInfo, String type) {
        this.saveCert(cerData, key, name, bankVersionID, null, null, certInfo, type);
    }

    public void saveCert(DynamicObject cerData, String key, String name, String bankVersionID, String bankLoginID, String accNo, CertInfo certInfo, String type) {
        cerData.set("bank_config_id", (Object)key);
        cerData.set("bank_config_value_tag", (Object)certInfo.getFileContent());
        cerData.set("bank_config_name", (Object)name);
        if (StringUtils.isNotEmpty((String)bankVersionID)) {
            cerData.set("bank_version_id", (Object)bankVersionID);
        }
        if (StringUtils.isNotEmpty((String)bankLoginID)) {
            cerData.set("bank_login_id", (Object)bankLoginID);
        }
        if (StringUtils.isNotEmpty((String)certInfo.getDownLoadPath())) {
            cerData.set("download_path", (Object)certInfo.getDownLoadPath());
        }
        if (StringUtils.isNotEmpty((String)accNo)) {
            cerData.set("acnt_no", (Object)accNo);
        }
        cerData.set("custom_id", (Object)certInfo.getCustomID());
        cerData.set("type", (Object)type);
        cerData.set("file_name", (Object)certInfo.getFileName());
        if (certInfo.getExpireTime() != null) {
            cerData.set("expire_time", (Object)Date.from(certInfo.getExpireTime().atZone(ZoneId.systemDefault()).toInstant()));
        }
        cerData.set("cert_type", (Object)certInfo.getCertType());
        cerData.set("is_alert", (Object)certInfo.isAlert());
        cerData.set("cert_source", (Object)certInfo.getCertSource());
        cerData.set("alert_day", (Object)certInfo.getAlertDay());
        cerData.set("cert_password", (Object)CipherCertUtil.encrypt((String)certInfo.getCertPassword()));
        String formId = this.getFormId();
        if (StringUtils.isNotEmpty((String)formId)) {
            cerData.set("source", (Object)formId);
        }
        SaveServiceHelper.save((IDataEntityType)cerData.getDataEntityType(), (Object[])new DynamicObject[]{cerData});
    }

    private String getFormId() {
        EBContext ebContext = EBContext.getContext();
        String formId = "";
        if (ebContext != null) {
            formId = ebContext.getFormId();
        }
        return formId;
    }

    public void addCert(String key, String name, String bankVersionID, CertInfo certInfo, String type) {
        this.addCert(key, name, bankVersionID, null, null, certInfo, type);
    }

    public void addCert(String key, String name, String bankVersionID, String bankLoginID, String accNo, CertInfo certInfo, String type) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)this.ENTITY_NAME);
        this.saveCert(dataEntity, key, name, bankVersionID, bankLoginID, accNo, certInfo, type);
    }

    public void delete(String bankLoginID, String customID) {
        DeleteServiceHelper.delete((String)this.ENTITY_NAME, (QFilter[])QFilter.of((String)"bank_login_id = ? and custom_id = ?", (Object[])new Object[]{bankLoginID, customID}).toArray());
    }

    public void update(String accountID, String newAccountID) {
        DynamicObject[] dynamicObject;
        for (DynamicObject dynamicObject1 : dynamicObject = this.findOneById(accountID)) {
            dynamicObject1.set("custom_id", (Object)newAccountID);
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObject);
    }

    public DynamicObject[] findOneById(String customID) {
        QFilter filter = QFilter.of((String)"custom_id=?", (Object[])new Object[]{customID});
        DynamicObject[] dynamicObject = BusinessDataServiceHelper.load((String)this.ENTITY_NAME, (String)this.selectProperties, (QFilter[])filter.toArray());
        return dynamicObject;
    }
}

