/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.transform.PaymentTransFormer;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

@Component
public class PaymentInfoRepository {
    EBGLogger log = EBGLogger.getInstance().getLogger(PaymentInfoRepository.class);
    private static final String DUPLICATE_ENTRY_INFO = "Duplicate entry";
    private static final String DUPLICATE_KEY_DETAIL_BIZ_NO = "FDETAIL_BIZ_NO";
    private String PAYMENTINFO_ENTITY = "aqap_bd_paymentinfo";
    private String SELECT_ALL_PROPERTIES = "id,custom_id,version,bank_login_id,ebg_id,bank_version_id,biz_type,sub_biz_type,impl_class_name,query_impl_class_name,package_key,total_count,total_amount,batch_seq_id,detail_seq_id,detail_biz_no,insert_batch_seq,insert_time,request_seq,request_time,update_time,update_batch_seq,update_operation,verify_field,amount,currency,use_code,use_cn,explanation,same_bank,same_city,urgent,individual,force,merge,fee_type,booking_time,emails,mobiles,acc_no,acc_name,bank_name,bank_address,area_code,acc_dept,acc_country,acc_province,acc_city,third_acc_no,third_acc_name,third_bank_name,third_bank_address,third_area_code,third_acc_dept,income_acc_no,income_acc_name,income_bank_name,income_bank_address,income_area_code,income_acc_dept,income_swift_code,income_cnaps,income_country,income_province,income_city,status_id,status_name,status_msg,bank_status,bank_msg,error_msg,error_stack,back_status,back_status_msg,back_bank_status,back_bank_msg,back_error_msg,back_error_stack,package_time,bank_batch_seq_id,bank_detail_seq_id,bank_serial_no,last_submit_time,last_submit_request_req,submit_count,submit_success_time,last_sync_time,last_sync_request_req,sync_count,pay_finish_date,to_give_up,payer_fee_type,payer_fee_acc_no,payer_fee_currency,exchange_rate,actual_amount,payee_bank_code,transaction_remarks,proxy_acc_no,proxy_acc_name,proxy_bank_country,proxy_bank_area,proxy_bank_swift_code,proxy_bank_name,proxy_bank_address,proxy_fee_type,proxy_fee_currency,pay_currency,ex_contract,bochk_message_bank,bbc_code_words,bank_ref_id,to_ground,iso_currency_code,iso_currency_name,clearing_code,clearing_branch_code,clearing_branch_sub_code,delivery_method,cheque_type,payment_method,service_level,trans_up,linkpay_type,relative_id,linkpay_detail_seq_id,reason,operator,reversed1,reversed2,reversed3,reversed4,reversed_biz_field,reversed_sys_field,income_branch_no,income_branch_name,abstract";

    public long countByStatusBetweenAndAccNoAndCustomID(int start, int end, String accNo, String customId) {
        QFilter filter = QFilter.of((String)"status_id >= ? and status_id <= ? and acc_no = ? and custom_id = ?", (Object[])new Object[]{start, end, accNo, customId});
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.PAYMENTINFO_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");){
            long total;
            long l = total = (long)ds.count("id", Boolean.FALSE.booleanValue());
            return l;
        }
    }

    public long countByBatchSeqID(String batchSeqID) {
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqID});
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.PAYMENTINFO_ENTITY, (String)"id", (QFilter[])filter.toArray(), (String)"");){
            long total;
            long l = total = (long)ds.count("id", Boolean.FALSE.booleanValue());
            return l;
        }
    }

    public List<PaymentInfo> findByBatchSeqIDAndEbgID(String batchSeqID, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"batch_seq_id = ? and ebg_id = ?", (Object[])new Object[]{batchSeqID, ebgID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByBatchSeqID(String batchSeqID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"batch_seq_id = ?", (Object[])new Object[]{batchSeqID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusBetweenAndUpdateTimeLessThanAndEbgIDOrderByUpdateTimeAsc(int start, int end, LocalDateTime time, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id >= ? and status_id <= ? and update_time < ? and ebg_id = ?", (Object[])new Object[]{start, end, time, ebgID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)"update_time asc")) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> getNeedToQueryPaymentInfo(boolean isMe, LocalDateTime time, String ebgID, int limitNum) {
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        List<String> bankVersionList = this.getUsedBankVersion();
        if (CollectionUtil.isEmpty(bankVersionList)) {
            return paymentInfos;
        }
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
        dynamicObjectList.addAll(this.queryPaymentInfos(PaymentState.UNKNOWN, time, bankVersionList));
        dynamicObjectList.addAll(this.queryPaymentInfos(PaymentState.SUBMITED, time, bankVersionList));
        for (DynamicObject dynamicObject : dynamicObjectList) {
            boolean flag;
            PaymentInfo paymentInfo = PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject);
            if (isMe) {
                flag = paymentInfo.getEbgID().equalsIgnoreCase(ebgID);
            } else {
                boolean bl = flag = !paymentInfo.getEbgID().equalsIgnoreCase(ebgID);
            }
            if (!flag) continue;
            PaymentState paymentState = PaymentState.getEnumById(paymentInfo.getStatus());
            if (paymentState == PaymentState.UNKNOWN && paymentInfo.getSyncCount() < limitNum) {
                paymentInfos.add(paymentInfo);
                continue;
            }
            if (paymentState != PaymentState.SUBMITED) continue;
            paymentInfos.add(paymentInfo);
        }
        return paymentInfos;
    }

    private List<DynamicObject> queryPaymentInfos(PaymentState paymentState, LocalDateTime time, List<String> bankVersionList) {
        ArrayList<DynamicObject> paymentInfos = new ArrayList<DynamicObject>(16);
        QFilter filter = QFilter.of((String)"status_id = ? and update_time < ?", (Object[])new Object[]{paymentState.getId(), time});
        filter.and(new QFilter("bank_version_id", "in", bankVersionList));
        filter.and(new QFilter("custom_id", "=", (Object)RequestContext.get().getTenantId()));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)"update_time asc");
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                paymentInfos.add(dynamicObject);
            }
        }
        return paymentInfos;
    }

    private List<String> getUsedBankVersion() {
        ArrayList<String> bankVersionList = new ArrayList<String>(16);
        String entityName = "aqap_bank";
        QFilter filter = QFilter.of((String)"enable=?", (Object[])new Object[]{"1"});
        Map maps = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"number", (QFilter[])filter.toArray());
        for (Map.Entry entry : maps.entrySet()) {
            DynamicObject dynamicObject = (DynamicObject)entry.getValue();
            bankVersionList.add(dynamicObject.getString("number"));
        }
        return bankVersionList;
    }

    public List<PaymentInfo> findByStatusBetweenAndUpdateTimeLessThanAndEbgIDAndSyncCountLessThanOrderByUpdateTimeAsc(int start, int end, LocalDateTime time, String ebgID, int limitNum) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id >= ? and status_id <= ? and update_time < ? and ebg_id = ? and sync_count < ?", (Object[])new Object[]{start, end, time, ebgID, limitNum});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)"update_time asc")) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusBetweenAndUpdateTimeLessThanAndEbgIDNot(int start, int end, LocalDateTime date, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id >= ? and status_id <= ? and ebg_id <> ? and update_time < ?", (Object[])new Object[]{start, end, ebgID, date});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusBetweenAndUpdateTimeLessThanAndEbgIDNotAndSyncCountLessThan(int start, int end, LocalDateTime date, String ebgID, int limitNum) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id >= ? and status_id <= ? and ebg_id <> ? and update_time < ? and sync_count < ?", (Object[])new Object[]{start, end, ebgID, date, limitNum});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusAndUpdateTimeLessThanAndEbgID(int status, LocalDateTime date, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id = ? and ebg_id = ? and update_time < ?", (Object[])new Object[]{status, ebgID, date});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByBatchSeqIDAndDetailSeqID(String batchSeqID, String detailSeqID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"batch_seq_id = ? and detail_seq_id = ?", (Object[])new Object[]{batchSeqID, detailSeqID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByBankBatchSeqID(String bankBatchSeqID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"bank_batch_seq_id = ? ", (Object[])new Object[]{bankBatchSeqID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findPackagedByBankBatchSeqID(String bankBatchSeqID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"bank_batch_seq_id = ? and status_id=?", (Object[])new Object[]{bankBatchSeqID, PaymentState.PACKAGED.getId()});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusAndUpdateTimeLessThanAndEbgIDNot(int status, LocalDateTime dateTime, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id = ? and update_time < ? and ebg_id <> ?", (Object[])new Object[]{status, dateTime, ebgID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusAndEbgID(int status, String ebgID) {
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id=? and ebg_id=?", (Object[])new Object[]{status, ebgID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
            }
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusAndEbgIDLimitHundred(int status, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id = ? and ebg_id = ?", (Object[])new Object[]{status, ebgID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray(), (String)"", (int)100)) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusAndUpdateTimeLessThanAndInsertTimeAfterAndEbgIDNot(int status, LocalDateTime dateTime, LocalDateTime insertTimeLimit, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id = ? and update_time < ? and insert_time > ? and ebg_id <> ?", (Object[])new Object[]{status, dateTime, insertTimeLimit, ebgID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusAndInsertTimeBetweenAndEbgIDNot(int status, LocalDateTime dateTime, LocalDateTime insertTimeLimit, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id = ? and insert_time < ? and insert_time > ? and ebg_id <> ?", (Object[])new Object[]{status, dateTime, insertTimeLimit, ebgID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByStatusAndUpdateTimeAfterAndEbgID(int status, LocalDateTime dateTime, String ebgID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id = ? and insert_time > ? and ebg_id = ?", (Object[])new Object[]{status, dateTime, ebgID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public List<PaymentInfo> findByUpdateTimeBeforeAndStatusBetween(LocalDateTime updateTime, int statusStart, int statusEnd) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"status_id >= ? and status_id <= ? and update_time < ?", (Object[])new Object[]{statusStart, statusEnd, updateTime});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public void deleteByUpdateTimeBeforeAndStatusBetween(LocalDateTime updateTime, int statusStart, int statusEnd) {
        QFilter filter = QFilter.of((String)"update_time < ? and status_id >= ? and status_id <= ?", (Object[])new Object[]{updateTime, statusStart, statusEnd});
        DeleteServiceHelper.delete((String)this.PAYMENTINFO_ENTITY, (QFilter[])filter.toArray());
    }

    public long countById(String id) {
        return 0L;
    }

    public PaymentInfo findByRelativeId(String relativeId) {
        QFilter filter = QFilter.of((String)"relative_id = ?", (Object[])new Object[]{relativeId});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        if (dynamicObject == null) {
            return null;
        }
        PaymentInfo paymentInfo = PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject);
        return paymentInfo;
    }

    public List<PaymentInfo> findByBatchSeqIDAndLinkpayDetailSeqId(String batchSeqID, String linkPayDetailSeqID) {
        DynamicObject[] dynamicObjects;
        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>(1);
        QFilter filter = QFilter.of((String)"batch_seq_id = ? and linkpay_detail_seq_id = ?", (Object[])new Object[]{batchSeqID, linkPayDetailSeqID});
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray())) {
            paymentInfos.add(PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject));
        }
        return paymentInfos;
    }

    public PaymentInfo findOne(String id) {
        QFilter filter = QFilter.of((String)"id = ?", (Object[])new Object[]{Long.parseLong(id)});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        PaymentInfo paymentInfo = PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject);
        return paymentInfo;
    }

    public List<PaymentInfo> save(List<PaymentInfo> paymentInfos) {
        this.updateAll(paymentInfos);
        return paymentInfos;
    }

    public void insertAll(List<PaymentInfo> paymentInfos) {
        if (paymentInfos.size() > 0) {
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
            for (PaymentInfo paymentInfo : paymentInfos) {
                dynamicObjectList.add(PaymentTransFormer.getInstance().transPaymentInfo(paymentInfo));
            }
            DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[paymentInfos.size()]);
            this.log.info("\u5f85\u63d2\u5165\u4ed8\u6b3e\u8bb0\u5f55\uff1a{}\u6761", (Object)paymentInfos.size());
            try {
                Object[] objs = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                for (int i = 0; i < objs.length; ++i) {
                    DynamicObject dynamicObject = (DynamicObject)objs[i];
                    paymentInfos.get(i).setId(dynamicObject.getString("id"));
                }
                this.log.info("\u4ed8\u6b3e\u8bb0\u5f55\u63d2\u5165\u5b8c\u6210");
            }
            catch (Exception e) {
                this.log.error("\u4ed8\u6b3e\u8bb0\u5f55\u63d2\u5165\u5931\u8d25");
                if (e.getMessage().contains(DUPLICATE_ENTRY_INFO) && e.getMessage().contains(DUPLICATE_KEY_DETAIL_BIZ_NO)) {
                    throw EBExceiptionUtil.duplicateException((String)this.getDuplicateKeyDetailBizNo(e.getMessage(), ResManager.loadKDString((String)"\u672c\u6b21\u63d0\u4ea4\u4ed8\u6b3e\u6307\u4ee4\u4e2d\uff0c\u68c0\u67e5\u5230\u5728\u9014\u6216\u4ea4\u6613\u6210\u529f\u7684\u4e1a\u52a1\u53f7\u3002", (String)"PaymentInfoRepository_0", (String)"ebg-aqap-common", (Object[])new Object[0])), (Throwable)e);
                }
                throw EBExceiptionUtil.dbSaveException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bb0\u5f55\u5165\u5e93\u4fdd\u5b58\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PaymentInfoRepository_1", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    public void updateAll(List<PaymentInfo> paymentInfos) {
        this.updateAll(paymentInfos, false);
    }

    public void updateAll(List<PaymentInfo> paymentInfos, boolean isManual) {
        if (paymentInfos.size() > 0) {
            String bankBatchSeqID = paymentInfos.get(0).getBankBatchSeqID();
            HashMap<String, DynamicObject> batchDynamicObjectMap = new HashMap<String, DynamicObject>(16);
            try {
                this.log.debug("\u5f85\u66f4\u65b0\u4ed8\u6b3e\u8bb0\u5f55\uff1a{}\u6761", (Object)paymentInfos.size());
                ArrayList<DynamicObject> toUpdateList = new ArrayList<DynamicObject>(1);
                for (PaymentInfo paymentInfo : paymentInfos) {
                    DynamicObject paymentDynamicObject;
                    ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(1);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.PAYMENTINFO_ENTITY);
                    dynamicObjectList.add(PaymentTransFormer.getInstance().transPaymentInfo(dynamicObject, paymentInfo));
                    DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[dynamicObjectList.size()]);
                    boolean isUpdate = PaymentTransFormer.getInstance().updateWithStatus(dynamicObjects, paymentInfo, isManual);
                    if (isUpdate) continue;
                    if (batchDynamicObjectMap.size() == 0) {
                        batchDynamicObjectMap.putAll(this.getBankBatchPayment(bankBatchSeqID));
                    }
                    if ((paymentDynamicObject = (DynamicObject)batchDynamicObjectMap.get(paymentInfo.getId())) == null) continue;
                    paymentDynamicObject.set("version", (Object)(dynamicObject.getInt("version") + 1));
                    paymentDynamicObject.set("update_time", (Object)Date.from(paymentInfo.getUpdateTime().atZone(ZoneId.systemDefault()).toInstant()));
                    paymentDynamicObject.set("sync_count", (Object)paymentInfo.getSyncCount());
                    paymentDynamicObject.set("query_impl_class_name", (Object)paymentInfo.getQueryImplClassName());
                    paymentDynamicObject.set("bank_ref_id", (Object)paymentInfo.getBankRefID());
                    paymentDynamicObject.set("reversed_sys_field", (Object)paymentInfo.getReversedSysField());
                    paymentDynamicObject.set("reversed_biz_field", (Object)paymentInfo.getReversedBizField());
                    paymentDynamicObject.set("reversed1", (Object)paymentInfo.getReversed1());
                    paymentDynamicObject.set("bank_status", (Object)paymentInfo.getBankStatus());
                    paymentDynamicObject.set("bank_msg", (Object)paymentInfo.getBankMsg());
                    toUpdateList.add(paymentDynamicObject);
                }
                if (toUpdateList.size() > 0) {
                    this.log.debug("\u5f53\u524d\u5b58\u5728\u4ed8\u6b3e\u72b6\u6001\u672a\u53d1\u751f\u53d8\u5316\u6216\u5df2\u88ab\u624b\u5de5\u4fee\u6539\uff0c\u4ed8\u6b3e\u72b6\u6001\u4e0d\u505a\u66f4\u65b0\uff0c\u4ec5\u66f4\u65b0\u4ed8\u6b3e\u5c5e\u6027\u503c");
                    SaveServiceHelper.update((DynamicObject[])toUpdateList.toArray(new DynamicObject[toUpdateList.size()]));
                }
                this.log.info("\u5f53\u524d\u4ed8\u6b3e\u72b6\u6001\u5df2\u66f4\u65b0\u5b8c\u6210");
            }
            catch (Exception e) {
                this.log.error("\u4ed8\u6b3e\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                if (e.getMessage().contains(DUPLICATE_ENTRY_INFO) && e.getMessage().contains(DUPLICATE_KEY_DETAIL_BIZ_NO)) {
                    throw EBExceiptionUtil.duplicateException((String)this.getDuplicateKeyDetailBizNo(e.getMessage(), ResManager.loadKDString((String)"\u66f4\u65b0\u4ed8\u6b3e\u8bb0\u5f55\u65f6\uff0c\u68c0\u67e5\u5230\u5728\u9014\u6216\u4ea4\u6613\u6210\u529f\u7684\u4e1a\u52a1\u53f7\u3002", (String)"PaymentInfoRepository_2", (String)"ebg-aqap-common", (Object[])new Object[0])), (Throwable)e);
                }
                throw EBExceiptionUtil.dbSaveException((String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bb0\u5f55\u5165\u5e93\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PaymentInfoRepository_3", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private Map<String, DynamicObject> getBankBatchPayment(String bankBatchSeqID) {
        DynamicObject[] collection;
        HashMap<String, DynamicObject> dynamicObjectMap = new HashMap<String, DynamicObject>(16);
        QFilter filter = QFilter.of((String)"bank_batch_seq_id=?", (Object[])new Object[]{bankBatchSeqID});
        for (DynamicObject dynamicObject : collection = BusinessDataServiceHelper.load((String)this.PAYMENTINFO_ENTITY, (String)"id,version,update_time,sync_count,query_impl_class_name,bank_ref_id,reversed_sys_field,reversed_biz_field,reversed1,bank_status,bank_msg", (QFilter[])filter.toArray())) {
            dynamicObjectMap.put(String.valueOf(dynamicObject.getLong("id")), dynamicObject);
        }
        return dynamicObjectMap;
    }

    private String getDuplicateKeyDetailBizNo(String errorMsg, String tips) {
        String result = tips;
        int startIndex = errorMsg.indexOf(DUPLICATE_ENTRY_INFO) + DUPLICATE_ENTRY_INFO.length();
        int endIndex = errorMsg.indexOf(DUPLICATE_KEY_DETAIL_BIZ_NO);
        if (startIndex > 0 && endIndex > 0 && endIndex > startIndex) {
            String msg = errorMsg.substring(startIndex, endIndex);
            String[] items = msg.split(" ");
            StringBuilder sb = new StringBuilder();
            for (String item : items) {
                int index = item.lastIndexOf(45);
                if (index <= 0) continue;
                item = item.substring(0, index);
                sb.append(tips).append('[').append(item.replaceAll("'", "")).append(']');
                break;
            }
            result = sb.toString();
        }
        return result;
    }

    public PaymentInfo findByBankDetailSeqID(String bankDetailSeqID) {
        QFilter filter = QFilter.of((String)"bank_detail_seq_id = ?", (Object[])new Object[]{bankDetailSeqID});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.PAYMENTINFO_ENTITY, (String)this.SELECT_ALL_PROPERTIES, (QFilter[])filter.toArray());
        PaymentInfo paymentInfo = null;
        if (dynamicObject != null) {
            paymentInfo = PaymentTransFormer.getInstance().packPaymentInfo(dynamicObject);
        }
        return paymentInfo;
    }
}

