/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.utils;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.annotation.SdkDeprecated;

@SdkDeprecated
public class ReflectUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReflectUtil.class);
    private static Map<String, List<Class>> classCache = new HashMap<String, List<Class>>(16);
    private static String packageName = "kd.ebg.aqap";
    private static List<String> packageScans = Lists.newArrayList((Object[])new String[]{"kd.ebg.aqap.common", "kd.ebg.aqap.business", "kd.ebg.aqap.mservice", "kd.ebg.aqap.formplugin", "kd.ebg.aqap.proxy"});

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return (T)Class.forName(clazz.getName()).newInstance();
        }
        catch (Exception var2) {
            return null;
        }
    }

    public static <T> T newInstance(String clazz) {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception var2) {
            return null;
        }
    }

    public static Set<Class<?>> getTypesAnnotatedWith(Class clazz) {
        HashSet classSet = new HashSet(16);
        for (String packageScan : packageScans) {
            classSet.addAll(ReflectUtil.getTypesAnnotatedWith(clazz, packageScan));
        }
        return classSet;
    }

    public static Set<Class<?>> getTypesAnnotatedWith(Class clazz, String packageScan) {
        HashSet classSet = new HashSet(16);
        if (StringUtils.isEmpty((String)packageScan)) {
            packageScan = packageName;
        }
        List<Class> allClass = ReflectUtil.getAllClassByPath(packageScan);
        for (Class c : allClass) {
            if (c.getAnnotation(clazz) == null) continue;
            classSet.add(c);
        }
        return classSet;
    }

    public static Set<Class<?>> getSubTypesOf(Class clazz) {
        try {
            return ReflectUtil.getSubTypesOf(clazz, packageName);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Set<Class<?>> getSubTypesOf(Class clazz, String packageScan) {
        HashSet classSet = new HashSet(16);
        if (clazz.isInterface()) {
            if (StringUtils.isEmpty((String)packageScan)) {
                packageScan = packageName;
            }
            List<Class> allClass = ReflectUtil.getAllClassByPath(packageScan);
            for (int i = 0; i < allClass.size(); ++i) {
                if (Modifier.isAbstract(allClass.get(i).getModifiers()) || !clazz.isAssignableFrom(allClass.get(i)) || clazz.equals(allClass.get(i))) continue;
                classSet.add(allClass.get(i));
            }
        }
        return classSet;
    }

    private static List<Class> getAllClassByPath(String packageName) {
        if (classCache.containsKey(packageName)) {
            return classCache.get(packageName);
        }
        ArrayList<Class> allClassList = new ArrayList<Class>(16);
        classCache.put(packageName, allClassList);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replaceAll("\\.", "\\/");
        try {
            Enumeration<URL> enumeration = classLoader.getResources(path);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                String type = url.getProtocol();
                if (!"jar".equalsIgnoreCase(type)) continue;
                try {
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    JarFile jarFile = jarURLConnection.getJarFile();
                    allClassList.addAll(ReflectUtil.getClassNameByJar(jarFile));
                }
                catch (IOException e) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return allClassList;
    }

    public static List<Class> getClassNameByJar(JarFile jarFile) {
        ArrayList<Class> classNames = new ArrayList<Class>(16);
        Enumeration<JarEntry> entrys = jarFile.entries();
        while (entrys.hasMoreElements()) {
            JarEntry jarEntry = entrys.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class")) continue;
            String className = entryName.replace("/", ".");
            className = className.substring(0, className.indexOf(".class"));
            try {
                classNames.add(Class.forName(className, false, Thread.currentThread().getContextClassLoader()));
            }
            catch (Throwable e) {
                logger.monitorError("find jar File error = " + jarFile.getName(), e);
            }
        }
        return classNames;
    }
}

