/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boimc.dc.service.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boimc.dc.service.ResponseChecker;
import kd.ebg.aqap.banks.boimc.dc.service.utils.DateFormatter;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public boolean isTodayDetailReverse() {
        return true;
    }

    public boolean isHistoryDetailReverse() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt bankAcnt = bankDetailRequest.getAcnt();
        if (bankAcnt.getAccNo() == null || bankAcnt.getAccNo().equals("")) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u4fe1\u606f\u4e3a\u7a7a", (String)"DetailImpl_0", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        }
        LocalDate startDate = bankDetailRequest.getStartDate();
        LocalDate endDate = bankDetailRequest.getEndDate();
        Element message = new Element("Message");
        Element head = new Element("Head");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2EActTrsQryEASId");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateFormatter.format2DateTime(new Date()));
        Element body = new Element("Body");
        JDomUtils.addChild((Element)message, (Element)body);
        Element list = new Element("List");
        JDomUtils.addChild((Element)body, (Element)list);
        Element map = new Element("Map");
        JDomUtils.addChild((Element)list, (Element)map);
        this.logger.info("\u67e5\u8be2\u660e\u7ec6\u8d26\u53f7\uff1a" + bankAcnt.getAccNo());
        this.logger.info("\u5f00\u59cb\u65e5\u671f\uff1a" + startDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        this.logger.info("\u7ed3\u675f\u65e5\u671f\uff1a" + endDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"AcNo", (String)bankAcnt.getAccNo());
        JDomUtils.addChild((Element)map, (String)"BeginDate", (String)startDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)map, (String)"EndDate", (String)endDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        return JDomUtils.root2String((Element)message, (String)"GBK");
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String resp) {
        ArrayList<DetailInfo> arrayList = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)resp, (String)"GBK");
        ResponseChecker.checkResponse(root, ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u4e1a\u52a1", (String)"DetailImpl_1", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"Body");
        Element list = JDomUtils.getChildElementNotNull((Element)body, (String)"List");
        List children = list.getChildren();
        Element child = (Element)children.get(0);
        String acNo = JDomUtils.getChildTextNotNull((Element)child, (String)"AcNo");
        BankAcnt bankAcnt = bankDetailRequest.getAcnt();
        if (!bankAcnt.getAccNo().equals(acNo)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u8d26\u53f7:%1$s\u3002", (String)"DetailImpl_21", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]), acNo));
        }
        String returnCode = JDomUtils.getChildTextNotNull((Element)child, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u72b6\u6001\u7801", (String)"DetailImpl_3", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        String returnMsg = JDomUtils.getChildTextNotNull((Element)child, (String)"ReturnMsg");
        if (!"000000".equals(returnCode)) {
            if (returnCode.equals("5K06") || returnMsg.equals(PropertiesConstants.getValue((String)"NOT_QUERY_RECORD"))) {
                return new EBBankDetailResponse(arrayList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u4e1a\u52a1\u51fa\u73b0\u5f02\u5e38, \u4ea4\u6613\u8fd4\u56de\u72b6\u6001\u7801:%1$s, \u9519\u8bef\u4fe1\u606f:%2$s", (String)"DetailImpl_22", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]), returnCode, JDomUtils.getChildText((Element)child, (String)"ReturnMsg")));
        }
        Element subList = JDomUtils.getChildElement((Element)child, (String)"List");
        List subChildren = subList.getChildren();
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < subChildren.size(); ++i) {
            Element element = (Element)subChildren.get(i);
            String dcFlag = JDomUtils.getChildTextNotNull((Element)element, (String)"DCFlag", (String)ResManager.loadKDString((String)"\u501f\u8d37\u6807\u5fd7", (String)"DetailImpl_6", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String amountStr = JDomUtils.getChildTextNotNull((Element)element, (String)"Amount", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"DetailImpl_7", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String transDate = JDomUtils.getChildTextNotNull((Element)element, (String)"TransDate", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"DetailImpl_8", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String transTime = JDomUtils.getChildText((Element)element, (String)"TransTime");
            String currency = JDomUtils.getChildTextNotNull((Element)element, (String)"Currency", (String)ResManager.loadKDString((String)"\u5e01\u79cd", (String)"DetailImpl_9", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String balanceStr = JDomUtils.getChildTextNotNull((Element)element, (String)"Balance", (String)ResManager.loadKDString((String)"\u4f59\u989d", (String)"DetailImpl_10", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String HostJnlNo = JDomUtils.getChildTextNotNull((Element)element, (String)"HostJnlNo", (String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7", (String)"DetailImpl_11", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String payerAcNo = JDomUtils.getChildTextNotNull((Element)element, (String)"PayerAcNo", (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7", (String)"DetailImpl_12", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String payerAcName = JDomUtils.getChildTextNotNull((Element)element, (String)"PayerAcName", (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u53f7\u540d\u79f0", (String)"DetailImpl_13", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String payerBankName = JDomUtils.getChildTextNotNull((Element)element, (String)"PayerBankName", (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u540d\u79f0", (String)"DetailImpl_14", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String PayeeAcNo = JDomUtils.getChildTextNotNull((Element)element, (String)"PayeeAcNo", (String)ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u8d26\u53f7", (String)"DetailImpl_15", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String PayeeAcName = JDomUtils.getChildTextNotNull((Element)element, (String)"PayeeAcName", (String)ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u540d\u79f0", (String)"DetailImpl_16", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String PayeeBankName = JDomUtils.getChildTextNotNull((Element)element, (String)"PayeeBankName", (String)ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u5f00\u6237\u884c\u540d", (String)"DetailImpl_17", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String remark = JDomUtils.getChildText((Element)element, (String)"Remark");
            String EASId = JDomUtils.getChildText((Element)element, (String)"EASId");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(acNo);
            detailInfo.setCurrency(currency);
            detailInfo.setBalance(BigDecimalHelper.str2BigDecimal((String)balanceStr));
            if (acNo.equals(payerAcNo)) {
                detailInfo.setOppAccNo(PayeeAcNo);
                detailInfo.setOppAccName(PayeeAcName);
                detailInfo.setOppBankName(PayeeBankName);
            } else {
                detailInfo.setOppAccNo(payerAcNo);
                detailInfo.setOppAccName(payerAcName);
                detailInfo.setOppBankName(payerBankName);
            }
            if (EASId.startsWith("KD")) {
                DetailSysFiled.set((DetailInfo)detailInfo, (String)"KDRetFlag", (String)"KD");
                DetailSysFiled.set((DetailInfo)detailInfo, (String)"batchNO", (String)EASId.substring(2, 10));
            }
            detailInfo.setExplanation(remark);
            if ("C".equalsIgnoreCase(dcFlag)) {
                detailInfo.setCreditAmount(kd.ebg.aqap.banks.boimc.dc.service.utils.BigDecimalHelper.str2BigDecimal(amountStr));
                detailInfo.setDebitAmount(kd.ebg.aqap.banks.boimc.dc.service.utils.BigDecimalHelper.ZERO);
            } else if ("D".equalsIgnoreCase(dcFlag)) {
                detailInfo.setCreditAmount(kd.ebg.aqap.banks.boimc.dc.service.utils.BigDecimalHelper.ZERO);
                detailInfo.setDebitAmount(kd.ebg.aqap.banks.boimc.dc.service.utils.BigDecimalHelper.str2BigDecimal(amountStr));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7:%1$s\u3002", (String)"DetailImpl_24", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]), dcFlag));
            }
            try {
                detailInfo.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                if (!StringUtils.isEmpty((String)transTime)) {
                    detailInfo.setTransTime(LocalDateTime.parse(transDate + transTime, DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss")));
                } else {
                    detailInfo.setTransTime(LocalDateTime.parse(transDate, DateTimeFormatter.ofPattern("yyyy-MM-ddHHmmss")));
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u5904\u7406\u9519\u8bef\uff1a%1$s\u3002", (String)"DetailImpl_25", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            JSONObject receiptJson = new JSONObject();
            receiptJson.put("accNo", (Object)acNo);
            receiptJson.put("transDate", (Object)transDate.replace("-", ""));
            receiptJson.put("serialNo", (Object)HostJnlNo);
            detailInfo.setJsonMap(receiptJson.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(acNo, transDate.replace("-", ""), receiptJson.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            arrayList.add(detailInfo);
        }
        return new EBBankDetailResponse(arrayList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

