/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boimc.dc.service.payment;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boimc.dc.service.ResponseChecker;
import kd.ebg.aqap.banks.boimc.dc.service.payment.BankCrossQueryPayImpl;
import kd.ebg.aqap.banks.boimc.dc.service.payment.PaymentChecker;
import kd.ebg.aqap.banks.boimc.dc.service.utils.BigDecimalHelper;
import kd.ebg.aqap.banks.boimc.dc.service.utils.DateFormatter;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BankCrossPayImpl
extends AbstractPayImpl
implements IPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BankCrossPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BankCrossQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        new PaymentChecker().check4Payment(paymentInfos);
        Element message = new Element("Message");
        Element head = new Element("Head");
        JDomUtils.addChild((Element)message, (Element)head);
        JDomUtils.addChild((Element)head, (String)"TrsCode", (String)"B2ECrossBankTransfer");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)DateFormatter.format2DateTime(new Date()));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)((PaymentInfo)paymentInfos.get(0)).getPackageId());
        this.logger.info("\u6d41\u6c34\u53f7ERPJnlNo\uff1a" + ((PaymentInfo)paymentInfos.get(0)).getPackageId());
        Element body = new Element("Body");
        JDomUtils.addChild((Element)message, (Element)body);
        Element list = new Element("List");
        JDomUtils.addChild((Element)body, (Element)list);
        Element map = new Element("Map");
        JDomUtils.addChild((Element)list, (Element)map);
        JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)map, (String)"PayerAcName", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        JDomUtils.addChild((Element)map, (String)"PayeeAcNo", (String)((PaymentInfo)paymentInfos.get(0)).getIncomeAccNo());
        JDomUtils.addChild((Element)map, (String)"PayeeAcName", (String)((PaymentInfo)paymentInfos.get(0)).getIncomeAccName());
        JDomUtils.addChild((Element)map, (String)"UnionDeptId", (String)((PaymentInfo)paymentInfos.get(0)).getIncomeCnaps());
        JDomUtils.addChild((Element)map, (String)"Currency", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        JDomUtils.addChild((Element)map, (String)"Amount", (String)BigDecimalHelper.plain2(((PaymentInfo)paymentInfos.get(0)).getAmount()));
        JDomUtils.addChild((Element)map, (String)"Priority", (String)(((PaymentInfo)paymentInfos.get(0)).is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)map, (String)"Remark", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)map, (String)"EASId", (String)("KD" + ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId()));
        PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo)((PaymentInfo)paymentInfos.get(0)));
        this.logger.info("PayerAcNo" + ((PaymentInfo)paymentInfos.get(0)).getAccNo());
        this.logger.info("PayerAcName" + ((PaymentInfo)paymentInfos.get(0)).getAccName());
        this.logger.info("PayeeAcNo" + ((PaymentInfo)paymentInfos.get(0)).getIncomeAccNo());
        this.logger.info("PayeeAcName" + ((PaymentInfo)paymentInfos.get(0)).getIncomeAccName());
        this.logger.info("UnionDeptId" + ((PaymentInfo)paymentInfos.get(0)).getIncomeCnaps());
        this.logger.info("Currency" + ((PaymentInfo)paymentInfos.get(0)).getCurrency());
        this.logger.info("Amount" + ((PaymentInfo)paymentInfos.get(0)).getAmount());
        this.logger.info("Priority" + ((PaymentInfo)paymentInfos.get(0)).is2Urgent());
        this.logger.info("Remark" + ((PaymentInfo)paymentInfos.get(0)).getExplanation());
        this.logger.info("paymentInfos.get(0)" + ((PaymentInfo)paymentInfos.get(0)).getExplanation());
        return JDomUtils.root2String((Element)message, (String)"GBK");
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String resp) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)resp, (String)"GBK");
        ResponseChecker.checkResponse(paymentInfos, root, ResManager.loadKDString((String)"\u8f6c\u5e10\u4ed8\u6b3e\u4e1a\u52a1", (String)"BankCrossPayImpl_0", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"Body");
        Element list = JDomUtils.getChildElementNotNull((Element)body, (String)"List");
        List maps = list.getChildren();
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            String returnCode = JDomUtils.getChildTextNotNull((Element)map, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"BankCrossPayImpl_1", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
            String returnMsg = JDomUtils.getChildText((Element)map, (String)"ReturnMsg");
            this.logger.info("\u8f6c\u5e10\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + returnCode + ", \u8f6c\u5e10\u8fd4\u56de\u4fe1\u606f\uff1a" + returnMsg);
            if ("000000".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"BankCrossPayImpl_2", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
                continue;
            }
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("eweb/B2ECrossBankTransfer.do?userPassword=" + RequestContextUtils.getBankParameterValue((String)"PASSWORD") + "&SIGDATA=1");
        factory.setHttpHeader("Content-Type", "charset=GBK");
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2ECrossBankTransfer";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

