/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boimc.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boimc.dc.service.payment.BankCrossPayImpl;
import kd.ebg.aqap.banks.boimc.dc.service.payment.BankInnerPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBBaseException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;

public class PretreatmentImpl
implements IPretreat {
    private void setSubBizType4Company(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) {
        if (paymentInfo.is2SameBank()) {
            busiImplInfo.setImplName(BankInnerPayImpl.class.getName());
        } else {
            busiImplInfo.setImplName(BankCrossPayImpl.class.getName());
        }
    }

    private void setSubBizType4Salary(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) throws EBServiceException {
        this.setSubBizType4Company(paymentInfo, busiImplInfo);
    }

    private void setSubBizType4CapitalAllocation(PaymentInfo paymentInfo, BusiImplInfo busiImplInfo) {
        paymentInfo.setToIndividual("false");
        if (!paymentInfo.is2SameBank()) {
            busiImplInfo.setImplName(BankCrossPayImpl.class.getName());
        } else {
            busiImplInfo.setImplName(BankInnerPayImpl.class.getName());
        }
    }

    public void appendData(PaymentInfo paymentInfo) {
        paymentInfo = this.pretreatPaymentInfo(paymentInfo);
        BusiImplInfo busiImplInfo = this.getBusiImplInfo(paymentInfo);
        paymentInfo.setImplClassName(busiImplInfo.getImplName());
        paymentInfo.setQueryImplClassName(busiImplInfo.getQueryImplName());
        paymentInfo.setPackageKey(busiImplInfo.getPackageKey());
    }

    private PaymentInfo pretreatPaymentInfo(PaymentInfo paymentInfo) throws EBBaseException {
        return paymentInfo;
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("accNo=").append(paymentInfo.getAccNo());
        packageKey.append(';');
        packageKey.append("sameBank=").append(paymentInfo.is2SameBank());
        packageKey.append(';');
        packageKey.append("urgent=").append(paymentInfo.is2Urgent());
        if ("income".equals(paymentInfo.getSubBizType())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5185\u8499\u53e4\u94f6\u884c\u6682\u672a\u652f\u6301\u6279\u6263\u4e1a\u52a1\u3002", (String)"PretreatmentImpl_0", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]));
        }
        if ("pay_for_capital_allocation".equals(paymentInfo.getSubBizType())) {
            this.setSubBizType4CapitalAllocation(paymentInfo, busiImplInfo);
        } else if ("pay_for_salary".equals(paymentInfo.getSubBizType())) {
            this.setSubBizType4Salary(paymentInfo, busiImplInfo);
        } else if ("pay_for_linkpay".equals(paymentInfo.getSubBizType())) {
            paymentInfo.setImplClassName(null);
        } else if ("pay".equals(paymentInfo.getSubBizType())) {
            if (UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
                this.setSubBizType4Salary(paymentInfo, busiImplInfo);
            } else if (UseConvertor.isTransfer((PaymentInfo)paymentInfo)) {
                this.setSubBizType4CapitalAllocation(paymentInfo, busiImplInfo);
            } else {
                this.setSubBizType4Company(paymentInfo, busiImplInfo);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u7c7b\u578b\u672a\u5b9e\u73b0\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_3", (String)"ebg-aqap-banks-boimc-dc", (Object[])new Object[0]), paymentInfo.getSubBizType()));
        }
        busiImplInfo.setPackageKey(packageKey.toString());
        return busiImplInfo;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

