/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbb.opa.services.balance;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbb.opa.services.utils.NBBUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBatchBalance;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance,
IHisBatchBalance {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public EBBankBalanceResponse batchBalance(BankBalanceRequest request) {
        ArrayList balances = new ArrayList(16);
        this.setCurrentPage("1");
        this.setLastPage(false);
        try {
            do {
                EBBankBalanceResponse response;
                if (!CollectionUtil.isNotEmpty((Collection)(response = this.doBiz(request)).getBalances())) continue;
                balances.addAll(response.getBalances());
            } while (!this.isLastPage());
            return new EBBankBalanceResponse(balances);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        String ret;
        this.setLastPage(true);
        String currentPage = this.getCurrentPage();
        int pageNum = Integer.parseInt(currentPage);
        try {
            NBBUtil.initSdk(request.getHeader().getCustomerID());
            JSONObject reqStr = new JSONObject();
            String custId = RequestContextUtils.getBankParameterValue((String)"custId");
            String startDate = request.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String endDate = request.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            List bankAcntList = request.getBankAcntList();
            JSONObject data = new JSONObject();
            data.put("custId", (Object)custId);
            JSONArray acnt = new JSONArray();
            for (BankAcnt account : bankAcntList) {
                acnt.add((Object)account.getAccNo());
            }
            data.put("bankAccList", (Object)acnt);
            data.put("beginDate", (Object)startDate);
            data.put("endnDate", (Object)endDate);
            data.put("pageSize", (Object)"20");
            data.put("currentPage", (Object)currentPage);
            reqStr.put("Data", (Object)data);
            ret = NBBUtil.send("accInfo", "queryAccount", reqStr.toJSONString(), this.getBizDesc());
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]), (Throwable)e);
        }
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        JSONObject retJson = JSONObject.parseObject((String)ret);
        JSONObject retData = retJson.getJSONObject("Data");
        String code = retData.getString("retCode");
        String msg = retData.getString("retMsg");
        if (!"0000".equalsIgnoreCase(code)) {
            logger.info("\u67e5\u8be2\u4f59\u989d\u94f6\u884c\u8fd4\u56de\u9519\u8bef{}", (Object)msg);
            return new EBBankBalanceResponse(balances);
        }
        JSONArray accountList = retData.getJSONArray("list");
        if (CollectionUtil.isEmpty((Collection)accountList)) {
            return new EBBankBalanceResponse(balances);
        }
        if (accountList.size() == 20) {
            this.setLastPage(false);
            this.setCurrentPage(pageNum + 1);
        }
        for (int i = 0; i < accountList.size(); ++i) {
            LocalDateTime updateTime;
            JSONObject acc = accountList.getJSONObject(i);
            String accNo = acc.getString("bankAcc");
            String bal = acc.getString("bal");
            String availBal = acc.getString("availBal");
            String lastTime = acc.getString("lastTime");
            String curCode = acc.getString("curCode");
            if (StringUtils.isEmpty((String)lastTime)) continue;
            lastTime = lastTime.replaceAll("[^0-9]", "");
            try {
                if (lastTime.length() == 14) {
                    updateTime = LocalDateTime.parse(lastTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                } else {
                    if (lastTime.length() != 8) continue;
                    updateTime = LocalDate.parse(lastTime, DateTimeFormatter.BASIC_ISO_DATE).atTime(0, 0);
                }
            }
            catch (DateTimeParseException e) {
                logger.error("\u65f6\u95f4\u683c\u5f0f\u6709\u8bef\u3002");
                continue;
            }
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfo.setCurrentBalance(new BigDecimal(bal));
            balanceInfo.setBalanceDateTime(updateTime);
            if (StringUtils.isNotEmpty((String)availBal)) {
                balanceInfo.setAvailableBalance(new BigDecimal(availBal));
            }
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(accNo);
            balanceInfo.setBankAcnt(bankAcnt);
            balanceInfo.setBankCurrency(curCode);
            balances.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "tmsReport/queryAccount";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u3002", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-nbb-opa", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        return null;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        return null;
    }

    public int limit() {
        return 1000;
    }
}

