/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringFormater;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Packer {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(Packer.class);

    public static Element createHead(String tr_code, String req_no) {
        Element ap = JDomUtils.createRoot((String)"ap");
        Element head = JDomUtils.addChild((Element)ap, (String)"head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)tr_code);
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"user_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"org_code", (String)"");
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)req_no);
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign", (String)"0");
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)"0");
        JDomUtils.addChild((Element)head, (String)"reserved", (String)"");
        return ap;
    }

    public static Element createHead(String tr_code, String req_no, boolean file) {
        Element ap = JDomUtils.createRoot((String)"ap");
        Element head = JDomUtils.addChild((Element)ap, (String)"head");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)tr_code);
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"user_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"org_code", (String)"");
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)req_no);
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign", (String)"0");
        if (file) {
            JDomUtils.addChild((Element)head, (String)"file_flag", (String)"1");
        } else {
            JDomUtils.addChild((Element)head, (String)"file_flag", (String)"0");
        }
        JDomUtils.addChild((Element)head, (String)"reserved", (String)"");
        return ap;
    }

    public static String buildCommonMsg(String xmlStr) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("00");
        buffer.append(xmlStr);
        return buffer.toString();
    }

    public static String formatLen(String orgStr, int exptecedLength) {
        try {
            String encoding = RequestContextUtils.getBankParameterValue((String)"charSet");
            return StringFormater.formatLen((String)orgStr, (int)exptecedLength, (boolean)true, (char)'0', (String)encoding);
        }
        catch (Exception e) {
            log.info("\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u51fa\u9519\uff0c", (Object)e);
            return "";
        }
    }

    public static int getLength(String msg) {
        String encoding = RequestContextUtils.getBankParameterValue((String)"charSet");
        try {
            int length = msg.getBytes(encoding).length;
            return length;
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u62a5\u6587\u5934+\u62a5\u6587\u4f53\u957f\u5ea6\u662f\u51fa\u9519", (Object)e);
            return 0;
        }
    }
}

