/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service.detail;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bod.cmp.service.Packer;
import kd.ebg.aqap.banks.bod.cmp.service.Parser;
import kd.ebg.aqap.banks.bod.cmp.service.ProxyDownload;
import kd.ebg.aqap.banks.bod.cmp.utils.BOD_CMPUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private static final String CIRCLE_STR = "|";

    public String pack(BankDetailRequest request) {
        Element root = Packer.createHead("200110", request.getHeader().getRequestSeqID());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String xmlMessage = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return Packer.buildCommonMsg(xmlMessage);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        List<Object> totalList = new ArrayList(16);
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserHead(root);
        if (!"0".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a%1$s\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a%2$s\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element head = root.getChild("head");
        Element body = root.getChild("body");
        if (null == body || null == body.getChildren() || body.getChildren().size() == 0) {
            return new EBBankDetailResponse(totalList);
        }
        String file_flag = head.getChildTextTrim("file_flag");
        log.info("\u4ea4\u6613\u660e\u7ec6\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        int record_num = Integer.parseInt(body.getChildTextTrim("record_num"));
        int field_num = Integer.parseInt(body.getChildTextTrim("field_num"));
        if (0 == record_num) {
            return new EBBankDetailResponse(totalList);
        }
        if ("0".equalsIgnoreCase(file_flag)) {
            String data = body.getChildTextTrim("serial_record");
            totalList = "BOD_CMP".equalsIgnoreCase(request.getHeader().getBankVersionID()) ? this.parserDetailData2(data, record_num, field_num) : this.parserDetailData(data, record_num, field_num);
        } else if ("1".equalsIgnoreCase(file_flag)) {
            String fileName = body.getChildTextTrim("file_name");
            ProxyDownload proxyDownload = new ProxyDownload();
            String data = proxyDownload.doBiz(fileName);
            totalList = "BOD_CMP".equalsIgnoreCase(request.getHeader().getBankVersionID()) ? this.parserDetailData2(data, record_num, field_num) : this.parserDetailData(data, record_num, field_num);
        }
        return new EBBankDetailResponse(totalList);
    }

    public String getDeveloper() {
        return "qiang";
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_2", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
    }

    private List<DetailInfo> parserDetailData(String data, int record_num, int field_num) {
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(1);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        String[] fields = StringUtils.split((String)data, (String)CIRCLE_STR);
        for (int i = 1; i <= record_num; ++i) {
            String host_serial_no = fields[i * field_num];
            String serial_no = fields[i * field_num + 1];
            String acno = fields[i * field_num + 2];
            String cur_code = fields[i * field_num + 3];
            String tr_acdt = fields[i * field_num + 4];
            String tr_time = fields[i * field_num + 5];
            String tr_bankno = fields[i * field_num + 6];
            String acname = fields[i * field_num + 7];
            String opp_acno = fields[i * field_num + 8];
            String opp_cur_code = fields[i * field_num + 9];
            String opp_acname = fields[i * field_num + 10];
            String opp_bankname = fields[i * field_num + 11];
            String opp_bankno = fields[i * field_num + 12];
            String tr_type = fields[i * field_num + 13];
            String csh_dra_flag = fields[i * field_num + 14];
            String bank_flag = fields[i * field_num + 15];
            String area_flag = fields[i * field_num + 16];
            String fee_amt = fields[i * field_num + 17];
            String tr_from = fields[i * field_num + 18];
            String trans_flag = fields[i * field_num + 19];
            String old_serial_no = fields[i * field_num + 20];
            String old_acdt = fields[i * field_num + 21];
            String cash_flag = fields[i * field_num + 22];
            String crdr_flag = fields[i * field_num + 23];
            String amt = fields[i * field_num + 24];
            String balance = fields[i * field_num + 25];
            String last_bal = fields[i * field_num + 26];
            String freeze_amt = fields[i * field_num + 27];
            String cert_type = fields[i * field_num + 28];
            String cert_batchno = fields[i * field_num + 29];
            String cert_no = fields[i * field_num + 30];
            String tr_code = fields[i * field_num + 31];
            String user_no = fields[i * field_num + 32];
            String sub_no = fields[i * field_num + 33];
            String purpose = fields[i * field_num + 34];
            String postscript = fields[i * field_num + 35];
            String tr_timestamp = fields[i * field_num + 36];
            String reserved1 = fields[i * field_num + 37];
            String reserved2 = fields[i * field_num + 38];
            String tr_bankname = fields[i * field_num + 39];
            String bank_no = fields[i + field_num + 40];
            String bankname = fields[i + field_num + 41];
            String printcount = fields[i + field_num + 42];
            String payamt = fields[i * field_num + 43];
            String rcvamt = fields[i * field_num + 44];
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acno);
            detail.setAccName(acname);
            detail.setTransType(tr_type);
            detail.setOppAccNo(opp_acno);
            detail.setOppAccName(opp_acname);
            detail.setOppBankName(opp_bankname);
            detail.setCurrency(cur_code);
            if (StringUtils.isNotEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            if (StringUtils.isNotEmpty((String)purpose) && purpose.contains("_KD_")) {
                String bankDetailSeqId = BizNoUtil.getId((String)purpose);
                String explanation = BizNoUtil.getMsg((String)purpose);
                detail.setPayBankDetailSeqID(bankDetailSeqId);
                detail.setExplanation(explanation);
            } else {
                detail.setExplanation(purpose);
            }
            detail.setDebitAmount(new BigDecimal(payamt));
            detail.setCreditAmount(new BigDecimal(rcvamt));
            if (!StringUtils.isEmpty((String)host_serial_no)) {
                DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)host_serial_no);
            }
            try {
                if (StringUtils.isEmpty((String)tr_acdt)) {
                    log.error("\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a");
                    continue;
                }
                detail.setTransTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                detail.setTransDate(LocalDate.parse(tr_acdt, DateTimeFormatter.ofPattern("yyyyMMdd")));
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
                continue;
            }
            detail.setBankDetailNo(serial_no);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("accNo", (Object)acno);
            jsonObject.put("tr_acdt", (Object)tr_acdt);
            jsonObject.put("serial_no", (Object)serial_no);
            jsonObject.put("summary", (Object)purpose);
            jsonObject.put("postscript", (Object)postscript);
            jsonObject.put("remark1", (Object)reserved1);
            jsonObject.put("remark2", (Object)reserved2);
            detail.setJsonMap(jsonObject.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(acno, tr_acdt, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            totalList.add(detail);
        }
        return totalList;
    }

    private List<DetailInfo> parserDetailData2(String data, int record_num, int field_num) {
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(1);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
        String[] fields = StringUtils.split((String)data, (String)CIRCLE_STR);
        for (int i = 1; i <= record_num; ++i) {
            String serial_no = fields[i * field_num];
            String acno = fields[i * field_num + 1];
            String cur_code = fields[i * field_num + 2];
            String tr_acdt = fields[i * field_num + 3];
            String tr_time = fields[i * field_num + 4];
            String host_serial_no = fields[i * field_num + 5];
            String acname = fields[i * field_num + 7];
            String opp_acno = fields[i * field_num + 8];
            String opp_acname = fields[i * field_num + 10];
            String opp_bankname = fields[i * field_num + 11];
            String tr_type = fields[i * field_num + 13];
            String balance = fields[i * field_num + 25];
            String purpose = fields[i * field_num + 34];
            String postscript = fields[i * field_num + 35];
            String reserved1 = fields[i * field_num + 37];
            String reserved2 = fields[i * field_num + 38];
            String payamt = fields[i * field_num + 43];
            String rcvamt = fields[i * field_num + 44];
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acno);
            detail.setAccName(acname);
            detail.setTransType(tr_type);
            detail.setOppAccNo(opp_acno);
            detail.setOppAccName(opp_acname);
            detail.setOppBankName(opp_bankname);
            detail.setCurrency(cur_code);
            if (StringUtils.isNotEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            if (StringUtils.isNotEmpty((String)payamt)) {
                detail.setDebitAmount(new BigDecimal(payamt));
            }
            if (StringUtils.isNotEmpty((String)rcvamt)) {
                detail.setCreditAmount(new BigDecimal(rcvamt));
            }
            if (StringUtils.isNotEmpty((String)purpose) && purpose.contains("_KD_")) {
                String bankDetailSeqId = BizNoUtil.getId((String)purpose);
                String explanation = BizNoUtil.getMsg((String)purpose);
                detail.setPayBankDetailSeqID(bankDetailSeqId);
                detail.setExplanation(explanation);
            } else {
                detail.setExplanation(purpose);
            }
            if (!StringUtils.isEmpty((String)host_serial_no)) {
                DetailSysFiled.set((DetailInfo)detail, (String)"bizRefNo", (String)host_serial_no);
            }
            try {
                if (StringUtils.isEmpty((String)tr_acdt)) {
                    log.error("\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a");
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65e5\u671f\u4e3a\u7a7a", (String)"DetailImpl_3", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]));
                }
                detail.setTransTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                detail.setTransDate(LocalDate.parse(tr_acdt, DateTimeFormatter.ofPattern("yyyyMMdd")));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            detail.setBankDetailNo(serial_no);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("accNo", (Object)acno);
            jsonObject.put("tr_acdt", (Object)tr_acdt);
            jsonObject.put("serial_no", (Object)serial_no);
            jsonObject.put("summary", (Object)purpose);
            jsonObject.put("postscript", (Object)postscript);
            jsonObject.put("remark1", (Object)reserved1);
            jsonObject.put("remark2", (Object)reserved2);
            detail.setJsonMap(jsonObject.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(acno, tr_acdt, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setReceiptNo(receiptNo);
            totalList.add(detail);
        }
        return totalList;
    }

    public String recv(InputStream inputStream) {
        return BOD_CMPUtils.parseRecvMsg(super.recv(inputStream));
    }

    public void configFactory(ConnectionFactory factory) {
        factory.addHeader("Content-Type", "application/x-www-form-urlencoded");
    }
}

