/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.ebg.aqap.banks.cus.BankBusinessConfig;
import kd.ebg.aqap.banks.cus.service.balance.HisBalanceImpl;
import kd.ebg.aqap.banks.cus.service.balance.TodayBalanceImpl;
import kd.ebg.aqap.banks.cus.service.detail.HisDetailImpl;
import kd.ebg.aqap.banks.cus.service.detail.TodayDetailImpl;
import kd.ebg.aqap.banks.cus.service.payment.PaymentImpl;
import kd.ebg.aqap.banks.cus.service.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.cus.service.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.cus.service.payment.linkpay.LinkPayImpl;
import kd.ebg.aqap.banks.cus.util.BankBatchSeqIdCreator;
import kd.ebg.aqap.banks.cus.util.BankDetailSeqIdCreator;
import kd.ebg.aqap.common.cache.CUSMetaDataCache;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.template.CUSMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.api.IBankBatchSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankDetailSeqIDCreator;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.sdk.ebg.cus.api.ISDKBankMetaData;
import kd.sdk.ebg.cus.bean.SDKBankBean;
import kd.sdk.ebg.cus.bean.SDKBankLoginConfigBean;
import kd.sdk.ebg.cus.bean.SDKDetailNoBean;
import kd.sdk.ebg.cus.bean.SDKMultiLangBean;

public class CusBankMetaDataImpl
extends CUSMetaDataTemplate {
    public void baseConfigInit() {
        ISDKBankMetaData bankMetaData = this.getBankSDKMetaData();
        if (bankMetaData != null) {
            SDKBankBean bankBean = bankMetaData.getBankBean();
            this.setExchangeProtocol(bankBean.getProtocol().getName());
            this.setCharSet(bankBean.getCharSet().getName());
            this.setTimeOut(bankBean.getTimeout_minute());
        } else {
            this.setExchangeProtocol("TCP");
            this.setCharSet("GB18030");
            this.setTimeOut(3);
        }
    }

    public void metaDataInit() {
        this.setBankName("CUS");
        this.setBankVersionID("CUS");
        this.setBankShortName("CUS");
        this.setBankVersionName("CUS Chinese");
        this.setDescription("CUS Chinese");
        this.setKeyNames(Lists.newArrayList((Object[])new String[]{"CUS"}));
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        ArrayList<BankLoginConfig> list = new ArrayList<BankLoginConfig>(1);
        ISDKBankMetaData bankMetaData = this.getBankSDKMetaData();
        if (bankMetaData != null) {
            List bankLoginConfigBeanList = bankMetaData.getBankLoginConfigBean();
            for (SDKBankLoginConfigBean bean : bankLoginConfigBeanList) {
                list.add(this.getBankLoginConfig(bean));
            }
        }
        return list;
    }

    private ISDKBankMetaData getBankSDKMetaData() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext != null) {
            String bankVersionID = ebContext.getBankVersionID();
            ISDKBankMetaData bankMetaData = CUSMetaDataCache.getInstance().getCUSMetaDataImpl(bankVersionID);
            return bankMetaData;
        }
        return null;
    }

    private BankLoginConfig getBankLoginConfig(SDKBankLoginConfigBean bean) {
        BankLoginConfig bankLoginConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)bean.getId(), (MultiLangEnumBridge)this.getMultiLangEnumBridge(bean.getMultiLangName()), (MultiLangEnumBridge)this.getMultiLangEnumBridge(bean.getMultiLangDesc()), (String)bean.getDefaultValue(), (boolean)bean.isReadonly(), (boolean)bean.isNullable(), (boolean)bean.isPassword());
        if (bean.getInputType() != null) {
            bankLoginConfig.setInputType(bean.getInputType().getInputType());
        }
        return bankLoginConfig;
    }

    private MultiLangEnumBridge getMultiLangEnumBridge(SDKMultiLangBean bean) {
        return new MultiLangEnumBridge(bean.getDescription(), bean.getDescription(), bean.getSystemType());
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{TodayBalanceImpl.class, HisBalanceImpl.class, TodayDetailImpl.class, HisDetailImpl.class, PretreatmentImpl.class, PaymentImpl.class, LinkPayImpl.class, QueryPaymentImpl.class});
    }

    public List<Class<? extends IBankBatchSeqIDCreator>> getBatchSeqIDClasses() {
        return Lists.newArrayList((Object[])new Class[]{BankBatchSeqIdCreator.class});
    }

    public List<Class<? extends IBankDetailSeqIDCreator>> getDetailSeqIDClasses() {
        return Lists.newArrayList((Object[])new Class[]{BankDetailSeqIdCreator.class});
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public Map<String, Map<String, String>> getDetailNoRule() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(16);
        HashMap<String, String> ruleMap = new HashMap<String, String>(16);
        result.put("default", ruleMap);
        ISDKBankMetaData bankMetaData = this.getBankSDKMetaData();
        if (bankMetaData != null) {
            SDKDetailNoBean bean = bankMetaData.getDetailNoBean();
            ruleMap.put("accNo", bean.getAccNoMapping());
            ruleMap.put("oppAccNo", bean.getOppAccNoMapping());
            ruleMap.put("transDate", bean.getTransDateMapping());
            ruleMap.put("Amount", bean.getAmountMapping());
            ruleMap.put("cdFlag", bean.getCdFlagMapping());
            ruleMap.put("serialNo", bean.getSerialNoMapping());
        } else {
            ruleMap.put("accNo", "accNo");
            ruleMap.put("oppAccNo", "oppAccNo");
            ruleMap.put("transDate", "transDate");
            ruleMap.put("Amount", "Amount");
            ruleMap.put("cdFlag", "cdFlag");
            ruleMap.put("serialNo", "serialNo");
        }
        return result;
    }

    public Map<String, String> getDetailUniqueRule() {
        List detailUniqueList;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(5);
        ISDKBankMetaData bankMetaData = this.getBankSDKMetaData();
        if (bankMetaData != null && (detailUniqueList = bankMetaData.getDetailUniqueRule()) != null) {
            for (String item : detailUniqueList) {
                result.put(item, DetailUniqueTypeEnum.STRING.getType());
            }
        }
        return result;
    }
}

