/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.service.dev;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cus.util.ShowTipUtil;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.cus.api.biz.other.ISDKCommon;
import kd.sdk.ebg.cus.api.biz.util.ISDKLoginCommon;

public class DevBankInterfaceImpl
extends AbstractBankXmlImpl
implements ISDKLoginCommon {
    private static Map<String, ISDKCommon> devCacheMap = new HashMap<String, ISDKCommon>(1);
    public static final String BANK_INTERFACE = "bank_interface";

    private String getKey(String bankVersionID, String bankInterfaceCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(bankVersionID).append('-').append(bankInterfaceCode);
        return sb.toString();
    }

    public ISDKCommon getImplFromCache(String bankInterfaceCode) {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        ISDKCommon isdkCommon = this.getImplFromCache(bankVersionID, bankInterfaceCode);
        if (isdkCommon != null) {
            return isdkCommon;
        }
        String msg = String.format(ResManager.loadKDString((String)"\u5b9a\u5236\u5316\u5f00\u53d1\u94f6\u884c\u63a5\u53e3\u672a\u627e\u5230\u63a5\u53e3\u5b9e\u73b0\u7c7b\uff0c\u94f6\u884c\u63a5\u53e3\u4e3a\uff1a%s\u3002", (String)"DevBankInterfaceImpl_2", (String)"ebg-aqap-banks-cus", (Object[])new Object[0]), bankInterfaceCode);
        throw EBExceiptionUtil.serviceException((String)msg);
    }

    private synchronized ISDKCommon getImplFromCache(String bankVersionID, String bankInterfaceCode) {
        Set clzImplSet;
        String key = this.getKey(bankVersionID, bankInterfaceCode);
        if (!devCacheMap.containsKey(key) && (clzImplSet = ReflectUtil.getSubTypesOf(ISDKCommon.class)) != null) {
            for (Class c : clzImplSet) {
                try {
                    ISDKCommon instance = (ISDKCommon)c.newInstance();
                    devCacheMap.put(this.getKey(bankVersionID, instance.getBankInterfaceCode()), instance);
                }
                catch (Throwable e) {
                    ShowTipUtil.recordLogError(ShowTipUtil.getNotFindClassTip(ISDKCommon.class.getName()), e);
                }
            }
        }
        ISDKCommon isdkCommon = devCacheMap.get(key);
        return isdkCommon;
    }

    public String doBiz(String bankInterfaceCode, String jsonStr) {
        RequestContextUtils.setRunningParam((String)BANK_INTERFACE, (String)bankInterfaceCode);
        ISDKCommon impl = this.getImplFromCache(bankInterfaceCode);
        if (!impl.isBankSDK()) {
            return this.doProcess(bankInterfaceCode, jsonStr);
        }
        try {
            String bankRequestStr = this.pack(bankInterfaceCode, jsonStr);
            ShowTipUtil.recordRequest(bankRequestStr);
            String bankResponseStr = impl.sendAndReceive(bankRequestStr);
            ShowTipUtil.recordResponse(bankResponseStr);
            return this.parse(bankInterfaceCode, bankResponseStr);
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    public String pack(String bankInterfaceCode, String jsonStr) {
        ISDKCommon impl = this.getImplFromCache(bankInterfaceCode);
        return impl.pack(jsonStr);
    }

    public String parse(String bankInterfaceCode, String bankResponseStr) {
        ISDKCommon impl = this.getImplFromCache(bankInterfaceCode);
        return impl.parse(bankResponseStr);
    }

    /*
     * Exception decompiling
     */
    public String doProcess(String bankInterfaceCode, String jsonStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void configFactory(ConnectionFactory factory) {
        String bankInterfaceCode = RequestContextUtils.getRunningParam((String)BANK_INTERFACE);
        ISDKCommon impl = this.getImplFromCache(bankInterfaceCode);
        if (impl != null) {
            String uri = impl.getHttpUri();
            if (StringUtils.isNotEmpty((String)uri)) {
                factory.setUri(uri);
            }
            Map httpHeaderMap = impl.getHttpHeader();
            for (Map.Entry entry : httpHeaderMap.entrySet()) {
                factory.setHttpHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

