/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.ebg.aqap.banks.cus.util.PaymentTransferUtil;
import kd.ebg.aqap.banks.cus.util.ShowTipUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ReflectUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.sdk.ebg.cus.api.biz.payment.ISDKPay;
import kd.sdk.ebg.cus.api.biz.payment.ISDKQueryPay;
import kd.sdk.ebg.cus.bean.biz.payment.SDKPayRouteInfo;

public class PayImplCacheUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(PayImplCacheUtil.class);
    private static Map<String, Set<ISDKPay>> payCacheMap = new HashMap<String, Set<ISDKPay>>(1);

    public static ISDKPay getImplFromCache() {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        Object obj = EBContext.getContext().getReDevResult();
        if (obj instanceof PaymentInfo) {
            PaymentInfo paymentInfo = (PaymentInfo)obj;
            SDKPayRouteInfo sdkPayRouteInfo = PaymentTransferUtil.transform(paymentInfo);
            return PayImplCacheUtil.getImplFromCache(bankVersionID, sdkPayRouteInfo);
        }
        return null;
    }

    private static synchronized void initPayCache() {
        Set clzImplSet = ReflectUtil.getSubTypesOf(ISDKPay.class);
        if (clzImplSet != null) {
            for (Class c : clzImplSet) {
                try {
                    ISDKPay instance = (ISDKPay)c.newInstance();
                    if (!payCacheMap.containsKey(instance.getBankVersionID())) {
                        payCacheMap.put(instance.getBankVersionID(), new HashSet(1));
                    }
                    Set<ISDKPay> paySet = payCacheMap.get(instance.getBankVersionID());
                    paySet.add(instance);
                }
                catch (Throwable e) {
                    logger.error(ShowTipUtil.getNotFindClassTip(ISDKPay.class.getName()), e);
                }
            }
        }
    }

    public static ISDKPay getImplFromCache(String bankVersionID, SDKPayRouteInfo sdkPayRouteInfo) {
        if (!payCacheMap.containsKey(bankVersionID)) {
            PayImplCacheUtil.initPayCache();
        }
        for (ISDKPay pay : payCacheMap.get(bankVersionID)) {
            if (!pay.matchPayRoute(sdkPayRouteInfo)) continue;
            return pay;
        }
        return null;
    }

    public static ISDKQueryPay getQueryImplFromCache() {
        String bankVersionID = EBContext.getContext().getBankVersionID();
        Object obj = EBContext.getContext().getReDevResult();
        if (obj instanceof PaymentInfo) {
            PaymentInfo paymentInfo = (PaymentInfo)obj;
            SDKPayRouteInfo sdkPayRouteInfo = PaymentTransferUtil.transform(paymentInfo);
            return PayImplCacheUtil.getQueryImplFromCache(bankVersionID, sdkPayRouteInfo);
        }
        return null;
    }

    public static ISDKQueryPay getQueryImplFromCache(String bankVersionID, SDKPayRouteInfo sdkPayRouteInfo) {
        ISDKPay isdkPay = PayImplCacheUtil.getImplFromCache(bankVersionID, sdkPayRouteInfo);
        if (isdkPay != null) {
            return isdkPay.queryPayImpl();
        }
        return null;
    }
}

