/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cus.util;

import kd.ebg.aqap.banks.cus.util.CusBeanUtils;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.sdk.ebg.cus.bean.bank.SDKBankHeader;
import kd.sdk.ebg.cus.bean.bank.payment.SDKPayRequest;
import kd.sdk.ebg.cus.bean.bank.payment.SDKPayResponse;
import kd.sdk.ebg.cus.bean.biz.payment.SDKPayRouteInfo;

public class PaymentTransferUtil {
    public static SDKPayRouteInfo transform(PaymentInfo paymentInfo) {
        SDKPayRouteInfo sdkPayRouteInfo = new SDKPayRouteInfo();
        sdkPayRouteInfo.setSubBizType(paymentInfo.getSubBizType());
        sdkPayRouteInfo.setAmount(paymentInfo.getAmount());
        sdkPayRouteInfo.setCurrency(paymentInfo.getCurrency());
        sdkPayRouteInfo.setExplanation(paymentInfo.getExplanation());
        sdkPayRouteInfo.setIndividual(paymentInfo.is2Individual());
        sdkPayRouteInfo.setSameBank(paymentInfo.is2SameBank());
        sdkPayRouteInfo.setUseCn(paymentInfo.getUseCN());
        sdkPayRouteInfo.setUrgent(paymentInfo.is2Urgent());
        return sdkPayRouteInfo;
    }

    public static SDKPayRequest transFormat(BankPayRequest payRequest) {
        SDKPayRequest request = new SDKPayRequest();
        SDKBankHeader sdkBankHeader = CusBeanUtils.transFormatHeader(payRequest.getHeader());
        request.setHeader(sdkBankHeader);
        CusBeanUtils.copyProperties(payRequest, request);
        request.setPaymentInfos(CusBeanUtils.transFormatSDKPaymentInfo(payRequest.getPaymentInfos()));
        return request;
    }

    public static EBBankPayResponse transFormat(SDKPayResponse sdkPayResponse, BankHeader header) {
        EBBankPayResponse response = new EBBankPayResponse();
        response.setHeader(header);
        response.setExtData(sdkPayResponse.getExtData());
        response.setBankBatchSeqID(sdkPayResponse.getBankBatchSeqID());
        response.setTotalAmount(sdkPayResponse.getTotalAmount());
        response.setTotalCount(sdkPayResponse.getTotalCount());
        response.setPaymentInfos(CusBeanUtils.transFormatPaymentInfo(sdkPayResponse.getPaymentInfos()));
        return response;
    }
}

