/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hrb.dc.service.detail;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hrb.dc.util.Base64Util;
import kd.ebg.aqap.banks.hrb.dc.util.StatusEnum;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private static final int PAGE_SIZE = 50;
    private static final String COMMON_SUCCESS = "0000000";

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(16);
        this.setCurrentPage("1");
        boolean isLastPage = false;
        this.setLastPage(isLastPage);
        while (!isLastPage) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            if (Objects.nonNull(detailResponse) && Objects.nonNull(detailResponse.getDetails())) {
                if (detailResponse.getDetails().size() == 0) break;
                detailInfos.addAll(detailResponse.getDetails());
            }
            this.setCurrentPage(String.valueOf(Integer.parseInt(this.getCurrentPage()) + 1));
            isLastPage = this.isLastPage();
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detail(request);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/corplink/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        Optional.of(acnt).orElseThrow(EBServiceException::new);
        Optional.of(acnt.getAccNo()).orElseThrow(EBServiceException::new);
        String custNo = RequestContextUtils.getBankParameterValue((String)"CUST_NO");
        Element BankData = new Element("BankData");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)BankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)StatusEnum.DETAIL_INFO.getCode());
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)String.valueOf(new Date().getTime()));
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
        Element reqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)reqParam);
        JDomUtils.addChild((Element)reqParam, (String)"cstNo", (String)custNo);
        JDomUtils.addChild((Element)reqParam, (String)"accountNo", (String)acnt.getAccNo());
        LocalDate startDate = bankDetailRequest.getStartDate();
        LocalDate endDate = bankDetailRequest.getEndDate();
        JDomUtils.addChild((Element)reqParam, (String)"beginDate", (String)startDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)reqParam, (String)"endDate", (String)endDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String bankCurrency = bankDetailRequest.getBankCurrency();
        if (StringUtils.isBlank((CharSequence)bankCurrency)) {
            bankCurrency = "01";
        }
        JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)bankCurrency);
        JDomUtils.addChild((Element)reqParam, (String)"turnPageBeginPos", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)reqParam, (String)"turnPageShowNum", (String)String.valueOf(50));
        String root2String = JDomUtils.root2String((Element)BankData, (String)RequestContextUtils.getCharset());
        root2String = StatusEnum.DETAIL_INFO.getCode() + "|" + custNo + "|1106|#" + root2String;
        this.logger.info("\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u62a5\u6587\u539f\u6587:{}", (Object)root2String);
        return Base64Util.compressDataAndEncode(root2String);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        String[] res = s.split("\\|");
        String code = res[0];
        if (!StringUtils.equals((CharSequence)code, (CharSequence)COMMON_SUCCESS)) {
            String msg = res[1];
            this.logger.error("\u67e5\u8be2\u4ea4\u6613\u5931\u8d25\uff0c\u9519\u8bef\u7801{}\uff0c\u9519\u8bef\u4fe1\u606f{}", new Object[]{code, msg});
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\u4e3a%s\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]), msg));
        }
        String xmlResult = s.substring(s.indexOf("#") + 1);
        Element root = JDomUtils.string2Root((String)xmlResult, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
        Element opResult = JDomUtils.getChildElementNotNull((Element)opRep, (String)"opResult");
        String turnPageTotalNum = JDomUtils.getChildTextNotNull((Element)opResult, (String)"turnPageTotalNum");
        if (StringUtils.isBlank((CharSequence)turnPageTotalNum) || turnPageTotalNum.equals("0")) {
            this.logger.info("\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u8bb0\u5f55\u4e3a\u7a7a");
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        if (StringUtils.isNotBlank((CharSequence)turnPageTotalNum) && Integer.parseInt(turnPageTotalNum) != 50) {
            this.setLastPage(true);
        }
        Element list = JDomUtils.getChildElementNotNull((Element)opResult, (String)"list");
        List children = list.getChildren();
        String acNo = JDomUtils.getChildTextNotNull((Element)opRep, (String)"accountNo");
        if (!StringUtils.equals((CharSequence)acNo, (CharSequence)bankDetailRequest.getAcnt().getAccNo())) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7\u4e0e\u67e5\u8be2\u8d26\u53f7\u4e0d\u7b26\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
        }
        ArrayList arrayList = new ArrayList(children.size());
        children.forEach(element -> {
            Element transElement = (Element)element;
            String dcFlag = JDomUtils.getChildTextNotNull((Element)transElement, (String)"DCFlag", (String)ResManager.loadKDString((String)"\u501f\u8d37\u6807\u8bb0", (String)"DetailImpl_2", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
            String partnerAccNo = JDomUtils.getChildTextNotNull((Element)transElement, (String)"partnerAccNo", (String)ResManager.loadKDString((String)"\u5bf9\u65b9\u8d26\u53f7", (String)"DetailImpl_3", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
            String partnerAccName = JDomUtils.getChildTextNotNull((Element)transElement, (String)"partnerAccName", (String)ResManager.loadKDString((String)"\u5bf9\u65b9\u6237\u540d", (String)"DetailImpl_4", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
            String partnerAccOpenBank = JDomUtils.getChildTextNotNull((Element)transElement, (String)"partnerAccOpenBank", (String)ResManager.loadKDString((String)"\u5bf9\u65b9\u884c\u540d", (String)"DetailImpl_5", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
            String transDate = JDomUtils.getChildTextNotNull((Element)transElement, (String)"transferDate", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"DetailImpl_6", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
            String transTime = JDomUtils.getChildTextNotNull((Element)transElement, (String)"transferTime", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4", (String)"DetailImpl_7", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
            String tranAmt = JDomUtils.getChildTextNotNull((Element)transElement, (String)"tranAmt", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"DetailImpl_8", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
            String balanceStr = JDomUtils.getChildTextNotNull((Element)transElement, (String)"balance", (String)ResManager.loadKDString((String)"\u4f59\u989d", (String)"DetailImpl_9", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
            String remark = JDomUtils.getChildText((Element)transElement, (String)"transDesc");
            String purpose = JDomUtils.getChildText((Element)transElement, (String)"purpose");
            DetailInfo.Builder builder = DetailInfo.builder().setAccNo(acNo).setCurrency("01").setOppAccNo(partnerAccNo).setOppAccName(partnerAccName).setOppBankName(partnerAccOpenBank).setExplanation(purpose);
            switch (dcFlag) {
                case "C": {
                    builder.setCreditAmount(new BigDecimal(tranAmt));
                    builder.setDebitAmount(BigDecimal.ZERO);
                    break;
                }
                case "D": {
                    builder.setCreditAmount(BigDecimal.ZERO);
                    builder.setDebitAmount(new BigDecimal(tranAmt));
                    break;
                }
                default: {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7\u3002", (String)"DetailImpl_10", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]), dcFlag));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)balanceStr)) {
                builder.setBalance(new BigDecimal(balanceStr));
            }
            builder.setTransDate(LocalDate.parse(transDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            builder.setTransTime(LocalDateTime.parse(transDate + " " + transTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(transElement);
            builder.setJsonMap(jsonStr);
            builder.setBankDetailNo(JDomUtils.getChildText((Element)transElement, (String)"erpFlowNo"));
            arrayList.add(builder.build());
        });
        return new EBBankDetailResponse(arrayList);
    }

    public String getDeveloper() {
        return "xs";
    }

    public String getBizCode() {
        return "CBE002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_11", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]);
    }
}

