/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hrb.dc.service.payment.inner;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hrb.dc.service.payment.inner.QueryPayImpl;
import kd.ebg.aqap.banks.hrb.dc.util.Base64Util;
import kd.ebg.aqap.banks.hrb.dc.util.StatusEnum;
import kd.ebg.aqap.banks.hrb.dc.util.SvsSignInfoSec;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PayImpl.class);
    private final String SUCCESS_CODE = "0000000";

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.is2SameBank();
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/corplink/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfoList = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = paymentInfoList.toArray(new PaymentInfo[paymentInfoList.size()]);
        String custNo = RequestContextUtils.getBankParameterValue((String)"CUST_NO");
        String signdataIp = RequestContextUtils.getBankParameterValue((String)"ip");
        String signPort = RequestContextUtils.getBankParameterValue((String)"signPort");
        Element BankData = new Element("BankData");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)BankData, (Element)opReq);
        int length = paymentInfos.length;
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)(length > 1 ? "CBE012" : "CBE003"));
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)paymentInfos[0].getBankBatchSeqID());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        String result = "";
        result = length == 1 ? this.addElementBySingle(ReqParam, paymentInfos, BankData) : this.addElementByMultiple(ReqParam, paymentInfos, BankData);
        logger.info("\u540c\u884c\u4ed8\u6b3e\u62a5\u6587\u539f\u6587:{}", (Object)result);
        return Base64Util.compressDataAndEncode(result);
    }

    private String addElementBySingle(Element reqParam, PaymentInfo[] paymentInfos, Element bankData) {
        PaymentInfo paymentInfo = paymentInfos[0];
        String accNo = paymentInfo.getAccNo();
        JDomUtils.addChild((Element)reqParam, (String)"payAccount", (String)accNo);
        JDomUtils.addChild((Element)reqParam, (String)"payAccountName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)reqParam, (String)"recAccount", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"recAccountName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)reqParam, (String)"payAmount", (String)String.valueOf(paymentInfo.getAmount()));
        String currency = paymentInfo.getCurrency();
        if (kd.ebg.egf.common.utils.string.StringUtils.isEmpty((String)currency)) {
            JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)"01");
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)currency);
        }
        JDomUtils.addChild((Element)reqParam, (String)"payUse", (String)paymentInfo.getExplanation());
        String reqTime = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss");
        String port = RequestContextUtils.getBankParameterValue((String)"signPort");
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String signData = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7801#CBE003|\u8bf7\u6c42\u65f6\u95f4#%1$s|\u4ed8\u6b3e\u8d26\u53f7#%2$s|\u6536\u6b3e\u8d26\u53f7#%3$s|\u6536\u6b3e\u6237\u540d#%4$s|\u4ea4\u6613\u91d1\u989d#%5$s", (String)"PayImpl_12", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]), reqTime, paymentInfos[0].getAccNo(), paymentInfos[0].getIncomeAccNo(), paymentInfos[0].getAccName(), paymentInfo.getAmount().toString());
        logger.info("\u540c\u884c\u4ed8\u6b3e\u7b7e\u540d\u539f\u6587\uff1a{}", (Object)signData);
        String sign = SvsSignInfoSec.signData(signData, ip, port);
        logger.info("\u540c\u884c\u4ed8\u6b3e\u7b7e\u540d\u503c\uff1a{}", (Object)sign);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        JDomUtils.addChild((Element)reqParam, (String)"signDataField", (String)signData);
        String cusNo = RequestContextUtils.getBankParameterValue((String)"CUST_NO");
        String root2String = StatusEnum.INNER_INFO.getCode() + "|" + cusNo + "|1106|#" + JDomUtils.root2String((Element)bankData, (String)RequestContextUtils.getCharset());
        return root2String;
    }

    private String addElementByMultiple(Element reqParam, PaymentInfo[] paymentInfos, Element bankData) {
        String port = RequestContextUtils.getBankParameterValue((String)"signPort");
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        Element list = new Element("list");
        JDomUtils.addChild((Element)reqParam, (Element)list);
        BigDecimal total = BigDecimal.ZERO;
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element row = new Element("row");
            JDomUtils.addChild((Element)row, (String)"payAccount", (String)paymentInfos[i].getAccNo());
            JDomUtils.addChild((Element)row, (String)"payAccountName", (String)paymentInfos[i].getAccName());
            JDomUtils.addChild((Element)row, (String)"recAccount", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)row, (String)"recAccountName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)row, (String)"payAmount", (String)String.valueOf(paymentInfos[i].getAmount()));
            logger.info("\u4ed8\u6b3e\u5e01\u79cd\uff1a" + paymentInfos[i].getCurrency());
            if (StringUtils.isNotBlank((CharSequence)paymentInfos[i].getCurrency())) {
                JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)paymentInfos[i].getCurrency());
            } else {
                JDomUtils.addChild((Element)reqParam, (String)"currencyType", (String)"01");
            }
            JDomUtils.addChild((Element)row, (String)"payUse", (String)paymentInfos[i].getExplanation());
            JDomUtils.addChild((Element)list, (Element)row);
            total = total.add(paymentInfos[i].getAmount());
        }
        JDomUtils.addChild((Element)reqParam, (String)"totalCnt", (String)String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)reqParam, (String)"totalAmt", (String)total.setScale(2, 4).toString());
        JDomUtils.addChild((Element)reqParam, (String)"payAccount", (String)paymentInfos[0].getAccNo());
        String reqTime = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss");
        String signData = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7801#CBE012|\u8bf7\u6c42\u65f6\u95f4#%1$s|\u4ed8\u6b3e\u8d26\u53f7#%2$s|\u603b\u91d1\u989d#%3$s|\u603b\u7b14\u6570#%4$s", (String)"PayImpl_13", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]), reqTime, paymentInfos[0].getAccNo(), total, paymentInfos.length);
        String sign = SvsSignInfoSec.signData(signData, ip, port);
        JDomUtils.addChild((Element)reqParam, (String)"signData", (String)sign);
        JDomUtils.addChild((Element)reqParam, (String)"signDataField", (String)signData);
        String cusNo = RequestContextUtils.getBankParameterValue((String)"CUST_NO");
        String reqMsg = StatusEnum.MULTI_INNER_INFO.getCode() + "|" + cusNo + "|1106|#" + JDomUtils.root2String((Element)bankData, (String)RequestContextUtils.getCharset());
        return reqMsg;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String resp) {
        List paymentInfoList = bankPayRequest.getPaymentInfos();
        PaymentInfo[] paymentInfos = paymentInfoList.toArray(new PaymentInfo[paymentInfoList.size()]);
        logger.info("\u54c8\u5c14\u6ee8\u94f6\u884c\u540c\u884c\u4ed8\u6b3e\u8fd4\u56de\u7ed3\u679c\uff1a" + resp);
        String[] result = resp.split("\\|");
        String reCode = result[0];
        if (!reCode.equalsIgnoreCase("0000000")) {
            logger.error("\u4ed8\u6b3e\u5931\u8d25\uff1a" + result[1]);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25\uff1a%s\u3002", (String)"PayImpl_14", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]), resp));
        }
        String xml = resp.split("#")[1];
        Element root = JDomUtils.string2Root((String)xml, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElementNotNull((Element)root, (String)"opRep");
        Element opResult = JDomUtils.getChildElementNotNull((Element)opRep, (String)"opResult");
        String orderState = JDomUtils.getChildText((Element)opResult, (String)"orderState");
        String responseResult = JDomUtils.getChildText((Element)opResult, (String)"responseResult");
        logger.error("\u4ea4\u6613\u8fd4\u56de\u7ed3\u679c\uff1a" + orderState);
        if ("90".equalsIgnoreCase(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_9", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]), (String)orderState, (String)PaymentState.SUBMITED.getCnName());
        } else if ("99".equalsIgnoreCase(orderState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.FAIL, (String)responseResult, (String)orderState, (String)responseResult);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)responseResult, (String)orderState, (String)responseResult);
        }
        return new EBBankPayResponse(Arrays.asList(paymentInfos));
    }

    public EBBankPayResponse pay(BankPayRequest request) {
        return super.pay(request);
    }

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "xs";
    }

    public String getBizCode() {
        return "CBE003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"PayImpl_10", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]);
    }
}

