/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balance.margin;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.services.Constants;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class MarginBalanceParser
implements Constants {
    public static EBBankBalanceResponse parseHisBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankAcnt)rqst.getAcnt(), (String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"MarginBalanceParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (BankResponse)response, (String)"0");
        Element xDataBody = root.getChild("xDataBody");
        Element acctList = xDataBody.getChild("acctList");
        List acctInfos = acctList.getChildren("acctInfo");
        HashMap balanceMap = new HashMap(16);
        for (Element element : acctInfos) {
            String accNo = JDomUtils.getChildText((Element)element, (String)"acctNo");
            HashMap<String, String> balanceInfoMap = new HashMap<String, String>(16);
            String acctBal = JDomUtils.getChildText((Element)element, (String)"acctBal");
            String acctName = JDomUtils.getChildText((Element)element, (String)"acctName");
            String currNo = JDomUtils.getChildText((Element)element, (String)"currNo");
            balanceInfoMap.put("acctName", acctName);
            balanceInfoMap.put("acctBal", acctBal);
            balanceInfoMap.put("currNo", currNo);
            balanceMap.put(accNo, balanceInfoMap);
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        String rqstccNo = rqst.getAcnt().getAccNo();
        String balance = (String)((Map)balanceMap.get(rqstccNo)).get("acctBal");
        if (StringUtils.isEmpty((String)balance)) {
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u5230:%s\u7684\u4f59\u989d\u3002", (String)"MarginBalanceParser_3", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), rqstccNo));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(rqst.getAcnt());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        balanceInfo.setCurrentBalance(new BigDecimal(balance));
        balanceInfo.setBankCurrency((String)((Map)balanceMap.get(rqst.getAcnt().getAccNo())).get("currNo"));
        balanceInfos.add(balanceInfo);
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        bankBalanceResponse.setBalances(balanceInfos);
        return bankBalanceResponse;
    }

    public static EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankAcnt)rqst.getAcnt(), (String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"MarginBalanceParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (BankResponse)response, (String)"0");
        Element xDataBody = root.getChild("xDataBody");
        Element acctList = xDataBody.getChild("acctList");
        List acctInfos = acctList.getChildren("acctInfo");
        HashMap balanceMap = new HashMap(16);
        for (Element element : acctInfos) {
            String accNo = JDomUtils.getChildText((Element)element, (String)"acctNo");
            HashMap<String, String> balanceInfoMap = new HashMap<String, String>(16);
            String acctBal = JDomUtils.getChildText((Element)element, (String)"acctBal");
            String acctName = JDomUtils.getChildText((Element)element, (String)"acctName");
            String currNo = JDomUtils.getChildText((Element)element, (String)"currNo");
            balanceInfoMap.put("acctName", acctName);
            balanceInfoMap.put("acctBal", acctBal);
            balanceInfoMap.put("currNo", currNo);
            balanceMap.put(accNo + currNo, balanceInfoMap);
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        String rqstccNo = rqst.getAcnt().getAccNo();
        String currency = rqst.getCurrency();
        Map value = (Map)balanceMap.get(rqstccNo + currency);
        if (value == null || StringUtils.isEmpty((String)((String)value.get("acctBal")))) {
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfo.setBankAcnt(rqst.getAcnt());
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            balanceInfo.setError(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u5230:%s\u7684\u4f59\u989d\u3002", (String)"MarginBalanceParser_3", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), rqstccNo));
            ArrayList balances = new ArrayList(16);
            return new EBBankBalanceResponse(balances);
        }
        String balance = (String)value.get("acctBal");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(rqst.getAcnt());
        BalanceUtil.setBalanceDateTime((BalanceInfo)balanceInfo, (LocalDateTime)LocalDateTime.now());
        BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)balance);
        BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)((String)value.get("currNo")));
        balanceInfos.add(balanceInfo);
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        bankBalanceResponse.setBalances(balanceInfos);
        return bankBalanceResponse;
    }
}

