/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.batch;

import java.math.BigDecimal;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Constants;
import kd.ebg.aqap.banks.cmbc.dc.services.ExplanationUtil;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker
implements Constants {
    public static String packPay(PaymentInfo[] paymentInfos, String code) throws EBServiceException {
        Element root = Packer.createMessageWithHead(code);
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)xdataBody, (String)"payerAcct", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"payType", (String)"0");
        JDomUtils.addChild((Element)xdataBody, (String)"totalRow", (String)("" + paymentInfos.length));
        BigDecimal total = PayPacker.getTotalAmt(paymentInfos);
        JDomUtils.addChild((Element)xdataBody, (String)"totalAmt", (String)BigDecimalHelper.plain2((BigDecimal)total));
        JDomUtils.addChild((Element)xdataBody, (String)"fileContent", (String)PayPacker.getFileContent(paymentInfos));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static String getFileContent(PaymentInfo[] infos) throws EBServiceException {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < infos.length; ++i) {
            String explanation;
            PayPacker.app(buffer, PayPacker.getFlag(infos[i]));
            PayPacker.app(buffer, infos[i].getBankDetailSeqId());
            PayPacker.app(buffer, "");
            PayPacker.app(buffer, "");
            PayPacker.app(buffer, infos[i].is2Individual() ? "1" : "0");
            PayPacker.app(buffer, infos[i].getIncomeAccNo());
            PayPacker.app(buffer, infos[i].getIncomeAccName());
            PayPacker.app(buffer, infos[i].is2SameBank() ? "" : infos[i].getIncomeCnaps());
            PayPacker.app(buffer, infos[i].is2SameBank() ? "" : infos[i].getIncomeBankName());
            if (BankBusinessConfig.isAddKDFlagToPay()) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)infos[i]);
                explanation = BizNoUtil.cont((String)infos[i].getBankDetailSeqId(), (String)ExplanationUtil.getExpOrAbs(infos[i]));
                PayPacker.app(buffer, explanation.length() > 20 ? explanation.substring(0, 20) : explanation);
            } else {
                explanation = ExplanationUtil.getExpOrAbs(infos[i]);
                PayPacker.app(buffer, explanation.length() > 20 ? explanation.substring(0, 20) : explanation);
            }
            PayPacker.app(buffer, "0");
            PayPacker.app(buffer, "");
            PayPacker.app(buffer, "");
            if (infos[i].is2Individual()) {
                String useCode = ExplanationUtil.convertExplToBank(infos[i].getExplanation(), infos[i].getAmount());
                PayPacker.app(buffer, useCode);
            } else {
                PayPacker.app(buffer, "");
            }
            PayPacker.appEnd(buffer, BigDecimalHelper.plain2((BigDecimal)infos[i].getAmount()));
            if (i == infos.length - 1) continue;
            String LINE_SEP = "^";
            buffer.append(LINE_SEP);
        }
        return buffer.toString();
    }

    private static void app(StringBuilder buffer, String field) {
        String FILED_SEP = "|";
        buffer.append(PayPacker.filter(field)).append(FILED_SEP);
    }

    private static void appEnd(StringBuilder buffer, String field) {
        buffer.append(PayPacker.filter(field));
    }

    private static String filter(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return "";
        }
        data = StringUtils.replace((String)data, (String)"|", (String)"-");
        data = StringUtils.replace((String)data, (String)"^", (String)"-");
        return data;
    }

    private static BigDecimal getTotalAmt(PaymentInfo[] paymentInfos) {
        BigDecimal total = BigDecimalHelper.ZERO;
        for (int i = 0; i < paymentInfos.length; ++i) {
            total = BigDecimalHelper.add((BigDecimal)total, (BigDecimal)paymentInfos[i].getAmount());
        }
        return total;
    }

    private static String getFlag(PaymentInfo info) {
        if (info.is2SameBank()) {
            return "0";
        }
        BigDecimal _5W = new BigDecimal("1000000.00");
        if (_5W.compareTo(info.getAmount()) > 0) {
            if (BankBusinessConfig.isCyberFlag()) {
                return "11";
            }
            return "6";
        }
        return "7";
    }
}

