/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bbgb.cms.services.detail;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class RespFileUtils
extends AbstractImpl {
    private static RespFileUtils instance = new RespFileUtils();

    public static RespFileUtils getInstance() {
        return instance;
    }

    public String getRspFileData(String fileName) {
        long waiting4DataTime = Long.parseLong(RequestContextUtils.getBankParameterValue((String)"waiting4Data"));
        try {
            Thread.sleep(waiting4DataTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        try {
            String rqstStr = this.pack(fileName);
            String rspStr = this.sendAndRecvMsg(rqstStr);
            return this.parse(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String pack(String fileName) throws EBServiceException {
        Element simulator = JDomUtils.createRoot((String)"simulator");
        Element head = this.createHead("fetchFile");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"fileName", (String)fileName);
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public String parse(String rspStr) throws EBServiceException {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse rsp = this.parseHeader(root);
        if (!"BIZ_SUCCESS".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 [%1$s %2$s]\u3002", (String)"RespFileUtils_3", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElementNotNull((Element)body, (String)"rspPara");
        Element status = JDomUtils.getChildElementNotNull((Element)rspPara, (String)"status");
        String ReturnCode = JDomUtils.getChildTextTrimNotNull((Element)status, (String)"code", (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u72b6\u6001\u7801", (String)"RespFileUtils_1", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextTrim((Element)status, (String)"msg");
        if (!"SUCCESS".equalsIgnoreCase(ReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38 [%1$s %2$s]\u3002", (String)"RespFileUtils_3", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]), ReturnCode, ReturnMsg));
        }
        return JDomUtils.getChildTextTrim((Element)rspPara, (String)"fileContent");
    }

    public Element createHead(String bizType) throws EBServiceException {
        return this.createHead(bizType, Sequence.genSequence());
    }

    public Element createHead(String bizType, String seqno) throws EBServiceException {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.format((Date)new Date(), (String)"HHmmss"));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public BankResponse parseHeader(Element root) throws EBServiceException {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"head");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"rspcode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"RespFileUtils_2", (String)"ebg-aqap-banks-bbgb-cms", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"rspMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }

    public String sendAndRecvMsg(String rqstStr) throws Exception {
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String portStr = RequestContextUtils.getBankParameterValue((String)"frontProxy_Port");
        String timeOutStr = RequestContextUtils.getBankParameterValue((String)"timeout");
        int port = Integer.parseInt(portStr);
        int timeOut = Integer.parseInt(timeOutStr);
        String rspStr = "";
        if (!EBContext.getContext().isUnitTest()) {
            try {
                HashMap header = new HashMap(16);
                HttpConnection conn = new HttpConnection(ip, port, "", header, timeOut);
                this.openConnection((IConnection)conn);
                try (OutputStream os = this.getOutputStream((IConnection)conn);){
                    this.send(os, rqstStr);
                    try (InputStream is = this.getInputStream((IConnection)conn);){
                        rspStr = this.recv(is);
                    }
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return rspStr;
    }
}

