/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ljb.dc.service.payment;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ljb.dc.service.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.ljb.dc.service.utils.CommonPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.entity.settleBankAccNo.SettleBankAccNoEntity;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        JSONObject bankRequest = CommonPacker.createRequest(paymentInfo.getBankDetailSeqId(), this.getBizCode());
        bankRequest.put("currency", (Object)paymentInfo.getPayCurrency());
        bankRequest.put("payAcctNo", (Object)paymentInfo.getAccNo());
        bankRequest.put("amt", (Object)paymentInfo.getAmount().toPlainString());
        bankRequest.put("rcvAcctNo", (Object)paymentInfo.getIncomeAccNo());
        bankRequest.put("rcvAcctName", (Object)paymentInfo.getIncomeAccName());
        bankRequest.put("rcvAcctKind", (Object)(paymentInfo.is2Individual() ? "1" : "2"));
        if (paymentInfo.is2SameBank() || !paymentInfo.is2SameBank() && paymentInfo.is2Urgent() && paymentInfo.getAmount().compareTo(new BigDecimal(1000000)) <= 0) {
            String bankName = paymentInfo.getIncomeBankName();
            SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
            SettleBankAccNoEntity settleBankAccNoEntity = settBankKeyWordsRepository.matchSettleBankByKey(bankName);
            if (settleBankAccNoEntity == null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u6e05\u7b97\u884c\u53f7\uff0c\u8bf7\u5728\u94f6\u4f01\u4e91\u5f55\u5165\u5bf9\u5e94\u6e05\u7b97\u884c\u4fe1\u606f\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-ljb-dc", (Object[])new Object[0]));
            }
            bankRequest.put("rcvBelongBankNo", (Object)settleBankAccNoEntity.getSettleAccno());
            bankRequest.put("rcvBelongBankName", (Object)settleBankAccNoEntity.getBankKey());
            if (!paymentInfo.is2SameBank()) {
                bankRequest.put("rcvBankNo", (Object)settleBankAccNoEntity.getSettleAccno());
                bankRequest.put("rcvBankName", (Object)settleBankAccNoEntity.getBankKey());
            } else {
                bankRequest.put("rcvBankNo", (Object)paymentInfo.getIncomeCnaps());
                bankRequest.put("rcvBankName", (Object)paymentInfo.getIncomeBankName());
            }
        } else {
            bankRequest.put("rcvBelongBankNo", (Object)paymentInfo.getIncomeCnaps());
            bankRequest.put("rcvBelongBankName", (Object)paymentInfo.getIncomeBankName());
            bankRequest.put("rcvBankNo", (Object)paymentInfo.getIncomeCnaps());
            bankRequest.put("rcvBankName", (Object)paymentInfo.getIncomeBankName());
        }
        bankRequest.put("transWay", (Object)(paymentInfo.is2Urgent() ? "1" : "0"));
        bankRequest.put("purpose", (Object)paymentInfo.getExplanation());
        bankRequest.put("remark", (Object)paymentInfo.getExplanation());
        return bankRequest.toJSONString();
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject response = JSONObject.parseObject((String)res);
        String respType = response.getString("respType");
        String respCode = response.getString("respCode");
        String respMsg = response.getString("respMsg");
        if ("S".equals(respType) || "W".equals(respType) || "P".equals(respType)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)respType, (String)respMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)respType, (String)respMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "02620100B0201";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-ljb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/json");
        super.configFactory(factory);
    }
}

