/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.BankBusinessConfig;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.services.LoginUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.PaymentUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class BatchBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        List acnts = bankBalanceRequest.getBankAcntList();
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSER18", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("00000886", Sequence.genSequence());
        JDomExtUtils.addChild((Element)body, (Element)request);
        int size = acnts.size();
        JDomExtUtils.addChildCDData(request, "Rvl_Rcrd_Num", Integer.toString(size));
        for (int i = 0; i < size; ++i) {
            Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
            JDomExtUtils.addChildCDData(list1, "Cash_Cst_AccNo", ((BankAcnt)acnts.get(i)).getAccNo());
            JDomExtUtils.addChildCDData(list1, "CshMgt_Acc_TpCd", "1");
            JDomExtUtils.addChildCDData(list1, "CcyCd", bankBalanceRequest.getBankCurrency());
        }
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        CCBHCBankResponse ccbhcBankResponse = CommonParser.getFrontResponse(rspStr);
        if (!ccbhcBankResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)ccbhcBankResponse.getResponseCode(), (String)ccbhcBankResponse.getResponseMessage()));
        }
        rspStr = ccbhcBankResponse.getBankMsg();
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        List acnts = bankBalanceRequest.getBankAcntList();
        BalanceInfo info = null;
        List list = response.getChildren("LIST1");
        int size = list.size();
        if (acnts.size() != size) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u7684\u8d26\u53f7\u6761\u6570\u548c\u8fd4\u56de\u7684\u6761\u6570\u4e0d\u4e00\u81f4,\u8bf7\u6c42\u6761\u6570\u4e3a\uff1a%s", (String)"BatchBalanceImpl_11", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), acnts.size()) + String.format(ResManager.loadKDString((String)" \u8fd4\u56de\u6761\u6570\u4e3a:%s\u3002", (String)"BatchBalanceImpl_12", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), size);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String count = response.getChildText("Rvl_Rcrd_Num");
        if (size != Integer.parseInt(count)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed9\u51fa\u7684\u5faa\u73af\u8bb0\u5f55\u6761\u6570,\u8ddf\u5b9e\u9645\u8fd4\u56de\u7684\u6761\u6570\u4e0d\u4e00\u81f4,\u8fd4\u56de\u7ed9\u51fa\u7684\u5faa\u73af\u8bb0\u5f55\u6761\u6570\u4e3a\uff1a%s", (String)"BatchBalanceImpl_13", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), count) + String.format(ResManager.loadKDString((String)" \u5b9e\u9645\u8fd4\u56de\u6761\u6570\u4e3a\uff1a%s\u3002", (String)"BatchBalanceImpl_14", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), size);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(16);
        for (int i = 0; i < size; ++i) {
            Element ele = (Element)list.get(i);
            BankAcnt acnt = (BankAcnt)acnts.get(i);
            String currency = JDomExtUtils.getChildText((Element)ele, (String)"CcyCd");
            String accAvlBal = JDomExtUtils.getChildText((Element)ele, (String)"Acc_Avl_Bal");
            String ystdBl = JDomExtUtils.getChildText((Element)ele, (String)"YstdBl");
            String infRpt_AcBa = JDomExtUtils.getChildText((Element)ele, (String)"InfRpt_AcBa");
            String accNo = JDomExtUtils.getChildText((Element)ele, (String)"Cash_Cst_AccNo");
            String frzAmt = JDomExtUtils.getChildText((Element)ele, (String)"Frz_Amt");
            info = new BalanceInfo();
            info.setBankAcnt(acnt);
            info.setBankCurrency(currency);
            info.setBalanceDateTime(LocalDateTime.now());
            infos.add(info);
            if (acnt.getAccNo().equals(accNo)) {
                if (BankBusinessConfig.currentBalanceChoose()) {
                    if (StringUtils.isEmpty((String)accAvlBal)) {
                        info.setError(ShowTipUtil.getBalanceEmptyTips((String)"InfRpt_AcBa"));
                        continue;
                    }
                    info.setCurrentBalance(new BigDecimal(infRpt_AcBa));
                } else {
                    if (StringUtils.isEmpty((String)accAvlBal)) {
                        info.setError(ShowTipUtil.getBalanceEmptyTips((String)"Acc_Avl_Bal"));
                        continue;
                    }
                    info.setCurrentBalance(new BigDecimal(accAvlBal));
                }
                if (StringUtils.isNotEmpty((String)accAvlBal)) {
                    info.setAvailableBalance(new BigDecimal(accAvlBal));
                }
                if (StringUtils.isNotEmpty((String)ystdBl)) {
                    info.setLastDayAvlBalance(new BigDecimal(ystdBl));
                }
                if (!StringUtils.isNotEmpty((String)frzAmt)) continue;
                info.setFreezeBalance(new BigDecimal(frzAmt));
                continue;
            }
            String errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u8d26\u53f7(%1$s)\u4e0e\u8fd4\u56de\u8d26\u53f7(%2$s)\u4e0d\u4e00\u81f4\uff1b", (String)"BatchBalanceImpl_15", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]), acnt.getAccNo(), accNo);
            info.setError(errMsg);
        }
        rsp.setBalances(infos);
        return rsp;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(BatchBalanceImpl.class);
        LoginUtils.login(logger);
        EBBankBalanceResponse response = super.doBiz(request);
        return response;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public int limit() {
        return 10;
    }

    public boolean match(BankBalanceRequest request) {
        return !PaymentUtils.isCaiziAcnt(request.getHeader().getAcnt().getAccNo());
    }
}

