/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccb.ccip.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccb.ccip.services.CCBHCBankResponse;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonPacker;
import kd.ebg.aqap.banks.ccb.ccip.services.CommonParser;
import kd.ebg.aqap.banks.ccb.ccip.utils.JDomExtUtils;
import kd.ebg.aqap.banks.ccb.ccip.utils.PaymentUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);
    public static final BigDecimal VCP_CURRENT_BALANCE = new BigDecimal("0.00");

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        return this.doBiz(request);
    }

    public String pack(BankBalanceRequest request) {
        if (PaymentUtils.isCaiziAcnt(request.getHeader().getAcnt().getAccNo())) {
            return this.packCaiziBalanceStr(request);
        }
        return this.packBalanceStr(request);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        if (PaymentUtils.isCaiziAcnt(request.getHeader().getAcnt().getAccNo())) {
            return this.parseCaiziBalance(request, responseStr);
        }
        return this.parseBalance(request, responseStr);
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "P1CMSET23";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e3b\u8d26\u6237\u4f59\u989d\u67e5\u8be2\u3002", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-ccb-ccip", (Object[])new Object[0]);
    }

    /*
     * Exception decompiling
     */
    public EBBankBalanceResponse doBiz(BankBalanceRequest rqst) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String packBalanceStr(BankBalanceRequest rqst) {
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSER18", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("00000886", Sequence.genSequence());
        JDomExtUtils.addChild((Element)body, (Element)request);
        JDomExtUtils.addChildCDData(request, "Rvl_Rcrd_Num", "1");
        Element list1 = JDomExtUtils.addChild((Element)request, (String)"LIST1");
        JDomExtUtils.addChildCDData(list1, "Cash_Cst_AccNo", rqst.getHeader().getAcnt().getAccNo());
        JDomExtUtils.addChildCDData(list1, "CshMgt_Acc_TpCd", "1");
        JDomExtUtils.addChildCDData(list1, "CcyCd", rqst.getHeader().getBankCurrency());
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public String packCaiziBalanceStr(BankBalanceRequest rqst) {
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.packCommonHeader("P1CMSER37", Sequence.genSequence());
        root.addContent((Content)headr);
        Element request = CommonPacker.packComEntity("00000886", Sequence.genSequence());
        JDomExtUtils.addChild((Element)body, (Element)request);
        JDomExtUtils.addChildCDData(request, "Rvl_Rcrd_Num", "1");
        JDomExtUtils.addChildCDData(request, "Cash_Cst_AccNo", rqst.getHeader().getAcnt().getAccNo());
        JDomExtUtils.addChildCDData(request, "CcyCd", rqst.getHeader().getBankCurrency());
        JDomExtUtils.addChildCDData(request, "Lqd_AcChar_Ind", "0");
        JDomExtUtils.addChildCDData(request, "CshEx_Cd", "1");
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankBalanceResponse parseBalance(BankBalanceRequest rqst, String rspStr) {
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        List list1 = response.getChildren("LIST1");
        Element list = (Element)list1.get(0);
        String currency = JDomExtUtils.getChildText((Element)list, (String)"CcyCd");
        String accAvlBal = JDomExtUtils.getChildText((Element)list, (String)"Acc_Avl_Bal");
        String odAmt = JDomExtUtils.getChildText((Element)list, (String)"Od_Amt");
        String ystdBl = JDomExtUtils.getChildText((Element)list, (String)"YstdBl");
        String frzAmt = JDomExtUtils.getChildText((Element)list, (String)"Frz_Amt");
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        BalanceInfo info = new BalanceInfo();
        if (StringUtils.isEmpty((String)accAvlBal)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getBalanceEmptyTips((String)"Acc_Avl_Bal"));
        }
        if (StringUtils.isNotEmpty((String)ystdBl)) {
            info.setLastDayAvlBalance(new BigDecimal(ystdBl));
        }
        if (StringUtils.isNotEmpty((String)frzAmt)) {
            info.setFreezeBalance(new BigDecimal(frzAmt));
        }
        info.setAvailableBalance(new BigDecimal(accAvlBal));
        info.setCurrentBalance(new BigDecimal(accAvlBal));
        info.setBankAcnt(rqst.getHeader().getAcnt());
        info.setBankCurrency(currency);
        info.setBalanceDateTime(LocalDateTime.now());
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        balanceInfos.add(info);
        rsp.setBalances(balanceInfos);
        return rsp;
    }

    public EBBankBalanceResponse parseCaiziBalance(BankBalanceRequest rqst, String rspStr) {
        CCBHCBankResponse bankResp = CommonParser.getBankPreResponse(rspStr);
        if (!bankResp.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage()));
        }
        Element root = JDomExtUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String currency = JDomExtUtils.getChildText((Element)response, (String)"CcyCd");
        String accAvlBal = JDomExtUtils.getChildText((Element)response, (String)"Acc_Avl_Bal");
        String currentBal = JDomExtUtils.getChildText((Element)response, (String)"CshPl_Bal");
        String odAmt = JDomExtUtils.getChildText((Element)response, (String)"Od_Amt");
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        BalanceInfo info = new BalanceInfo();
        this.setCurrentBalance(info, currentBal);
        this.setAvailableBalance(info, accAvlBal);
        info.setLastDayAvlBalance(new BigDecimal("0.00"));
        info.setBankAcnt(rqst.getHeader().getAcnt());
        info.setBankCurrency(currency);
        info.setBalanceDateTime(LocalDateTime.now());
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        balanceInfos.add(info);
        rsp.setBalances(balanceInfos);
        return rsp;
    }
}

