/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hnb.dc.service.payment.salary;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hnb.dc.service.payment.salary.SalaryQueryPayImpl;
import kd.ebg.aqap.banks.hnb.dc.service.proxy.FileUpload;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Packer;
import kd.ebg.aqap.banks.hnb.dc.util.HNB_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay {
    public static final String template_salary = "acno|cur_code|acname|cardflag|amt|postscript|";

    public EBBankPayResponse pay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "300002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u4ee3\u53d1", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equals(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = HNB_DC_Packer.buildHead("300002", Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        if (UseConvertor.isReim((PaymentInfo)paymentInfo)) {
            JDomUtils.addChild((Element)body, (String)"supply_item", (String)"0002");
        } else if (UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            JDomUtils.addChild((Element)body, (String)"supply_item", (String)"0001");
        }
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfo.getBankBatchSeqID());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"record_num", (String)String.valueOf(paymentInfos.size()));
        JDomUtils.addChild((Element)body, (String)"field_num", (String)"6");
        String fileName = paymentInfo.getBankBatchSeqID() + ".txt";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        BigDecimal totalAmt = new BigDecimal("0.00");
        StringBuilder fileTextBuffer = new StringBuilder();
        fileTextBuffer.append(template_salary).append("\r\n");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            fileTextBuffer.append("|");
            totalAmt = totalAmt.add(((PaymentInfo)paymentInfos.get(i)).getAmount());
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccNo()).append("|");
            fileTextBuffer.append("01").append("|");
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getIncomeAccName()).append("|");
            fileTextBuffer.append("0").append("|");
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getAmount().toString()).append("|");
            fileTextBuffer.append(((PaymentInfo)paymentInfos.get(i)).getExplanation()).append("|");
            if (i >= paymentInfos.size() - 1) continue;
            fileTextBuffer.append("\r\n");
        }
        JDomUtils.addChild((Element)body, (String)"amt", (String)totalAmt.setScale(2, 1).toString());
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        FileUpload fileUpLoad = new FileUpload();
        fileUpLoad.setFileContent(fileTextBuffer.toString());
        fileUpLoad.doBiz(fileName);
        return HNB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)(responseStr = responseStr.substring(responseStr.indexOf("<ap>"))), (String)encoding);
        BankResponse rsp = HNB_DC_Parser.parseResponeCode(root);
        if ("0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryPayImpl_1", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryPayImpl_2", (String)"ebg-aqap-banks-hnb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
        factory.setHttpHeader("Content-Encoding", "GBK");
    }
}

