/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zyb.dc.services.payment.salary.batch;

import java.math.BigDecimal;
import kd.ebg.aqap.banks.zyb.dc.utils.GLBPacker;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPacker {
    EBGLogger log = EBGLogger.getInstance().getLogger(SalaryPacker.class);
    private static final String TRANCODE = "05B2EAgentPaySalary";

    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)GLBPacker.getHeadPackerData2(TRANCODE, paymentInfos));
        Element body = JDomUtils.addChild((Element)ebank_root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayerAcNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayerAccountName", (String)paymentInfos[0].getAccName());
        boolean isurgent = paymentInfos[0].is2Urgent();
        Element List2 = new Element("List");
        BigDecimal totalamt = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            Element Row = new Element("Row");
            JDomUtils.addChild((Element)Row, (String)"PayeeAcNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)Row, (String)"PayeeAcName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)Row, (String)"TrsAmount", (String)paymentInfos[i].getAmount().toString());
            JDomUtils.addChild((Element)Row, (String)"Remark", (String)paymentInfos[i].getExplanation());
            JDomUtils.addChild((Element)List2, (Element)Row);
            totalamt = totalamt.add(paymentInfos[i].getAmount());
        }
        JDomUtils.addChild((Element)body, (String)"TotalAmount", (String)String.valueOf(totalamt));
        JDomUtils.addChild((Element)body, (String)"TotalCount", (String)String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)body, (Element)List2);
        String requestXml = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        return requestXml;
    }
}

