/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.alipay.cmp.service.payment;

import com.alipay.api.AlipayApiException;
import com.alipay.api.request.AlipayFundTransCommonQueryRequest;
import com.alipay.api.response.AlipayFundTransCommonQueryResponse;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.alipay.cmp.utils.AlipayRequestUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPaymentImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        this.logger.info("\u652f\u4ed8\u5b9d\u540c\u6b65\u4ed8\u6b3e\u6d41\u7a0b\u5f00\u59cb");
        AlipayFundTransCommonQueryRequest request = new AlipayFundTransCommonQueryRequest();
        AlipayFundTransCommonQueryResponse response = null;
        String out_biz_no = info.getBankDetailSeqId();
        String product_code = "TRANS_ACCOUNT_NO_PWD";
        String biz_scene = "DIRECT_TRANSFER";
        request.setBizContent("{\"product_code\":\"" + product_code + "\",\"biz_scene\":\"" + biz_scene + "\",\"out_biz_no\":\"" + out_biz_no + "\"}");
        this.logger.info("\u8bf7\u6c42\u62a5\u6587\uff1a" + request.getBizContent());
        try {
            response = (AlipayFundTransCommonQueryResponse)AlipayRequestUtil.execute(request, info.getAccNo());
        }
        catch (AlipayApiException e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
        if (!response.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7f51\u5173\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%1$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\uff1a%2$s\uff0c\u4e1a\u52a1\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%3$s", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-alipay-cmp", (Object[])new Object[0]), response.getMsg(), response.getSubCode(), response.getSubMsg()));
        }
        String status = response.getStatus();
        String error_code = response.getErrorCode();
        String fail_reason = response.getFailReason();
        if ("SUCCESS".equals(status) && StringUtils.isEmpty((String)error_code) && StringUtils.isEmpty((String)fail_reason)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)status, (String)"");
        } else if ("FAIL".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)error_code, (String)status, (String)fail_reason);
        } else if ("DEALING".equals(status)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)status, (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)fail_reason, (String)status, (String)fail_reason);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

