/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gzcb.dc.services.payment;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gzcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.gzcb.dc.GZCBEBankDataHelper;
import kd.ebg.aqap.banks.gzcb.dc.helper.DomHelper;
import kd.ebg.aqap.banks.gzcb.dc.limit.PayLoginAccess;
import kd.ebg.aqap.banks.gzcb.dc.limit.PayLoginAccessManager;
import kd.ebg.aqap.banks.gzcb.dc.loginout.LoginAndOut;
import kd.ebg.aqap.banks.gzcb.dc.services.payment.QueryPayImpl;
import kd.ebg.aqap.banks.gzcb.dc.sign.SignService;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    private int contentLength = 0;

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u666e\u901a\u4ed8\u6b3e\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        if (paymentInfo.is2SameBank()) {
            return this.pack4SameBank(paymentInfo);
        }
        return this.pack4DiffBank(paymentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pack4SameBank(PaymentInfo paymentInfo) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        try {
            la.getToken();
            String sessionId = LoginAndOut.getLoginAndOut().loginSessionId4Query();
            Element GZCBEBankData = new Element("GZCBEBankData");
            Element opReq = JDomUtils.addChild((Element)GZCBEBankData, (String)"opReq");
            String serialNo = paymentInfo.getBankDetailSeqId();
            JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
            String date = DateUtil.formatDateTime((Date)new Date());
            JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)date);
            Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
            JDomUtils.addChild((Element)ReqParam, (String)"FKZH", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)ReqParam, (String)"FKHM", (String)paymentInfo.getAccName());
            JDomUtils.addChild((Element)ReqParam, (String)"SKZH", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)ReqParam, (String)"SKHM", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)ReqParam, (String)"JYJE", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
            JDomUtils.addChild((Element)ReqParam, (String)"BIZH", (String)paymentInfo.getCurrency());
            JDomUtils.addChild((Element)ReqParam, (String)"YOTU", (String)paymentInfo.getExplanation());
            String sign = serialNo + "|" + date + "|" + paymentInfo.getAccNo() + "|" + paymentInfo.getAccName() + "|" + paymentInfo.getIncomeAccNo() + "|" + paymentInfo.getIncomeAccName() + "|" + BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()) + "|" + paymentInfo.getCurrency() + "|" + paymentInfo.getExplanation() + "|";
            Element signInfo = JDomUtils.addChild((Element)GZCBEBankData, (String)"signInfo");
            SignService signService = new SignService();
            JDomUtils.addChild((Element)signInfo, (String)"signed_data", (String)signService.sign(sign));
            Document document = new Document(GZCBEBankData);
            String xml = DomHelper.doc2StringPlain(document, RequestContextUtils.getCharset());
            String saq = GZCBEBankDataHelper.add(xml, sessionId, "srv006_singleInnerTransfer");
            try {
                this.contentLength = saq.getBytes(RequestContextUtils.getCharset()).length;
            }
            catch (UnsupportedEncodingException e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            String string = saq;
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (EBServiceException e) {
                EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91ca\u653e\u8bbf\u95ee\u7968\u5f02\u5e38\uff1a\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (Throwable)e).printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String pack4DiffBank(PaymentInfo paymentInfo) {
        PayLoginAccess la = PayLoginAccessManager.searchLock();
        try {
            la.getToken();
            String sessionId = LoginAndOut.getLoginAndOut().loginSessionId4Query();
            Element GZCBEBankData = new Element("GZCBEBankData");
            Element opReq = JDomUtils.addChild((Element)GZCBEBankData, (String)"opReq");
            String serialNo = paymentInfo.getBankDetailSeqId();
            JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)serialNo);
            String date = DateUtil.formatDateTime((Date)new Date());
            JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)date);
            Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
            JDomUtils.addChild((Element)ReqParam, (String)"FKZH", (String)paymentInfo.getAccNo());
            JDomUtils.addChild((Element)ReqParam, (String)"FKHM", (String)paymentInfo.getAccName());
            JDomUtils.addChild((Element)ReqParam, (String)"SKZH", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)ReqParam, (String)"SKHM", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)ReqParam, (String)"SKYH", (String)paymentInfo.getIncomeBankName());
            String addres = paymentInfo.getIncomeBankAddress();
            if (StringUtils.isEmpty((String)addres)) {
                addres = "";
            }
            JDomUtils.addChild((Element)ReqParam, (String)"SKDQ", (String)addres);
            String cnaps = paymentInfo.getIncomeCnaps();
            if (StringUtils.isEmpty((String)cnaps)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8de8\u884c\u4ed8\u6b3e\u8054\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)ReqParam, (String)"LHHM", (String)cnaps);
            JDomUtils.addChild((Element)ReqParam, (String)"JYJE", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
            JDomUtils.addChild((Element)ReqParam, (String)"BIZH", (String)paymentInfo.getCurrency());
            String ZZLX = "11";
            String city = cnaps.substring(3, 5);
            if (city.equals("58") || city.equals("59") || city.equals("60")) {
                ZZLX = "10";
            }
            JDomUtils.addChild((Element)ReqParam, (String)"ZZLX", (String)ZZLX);
            JDomUtils.addChild((Element)ReqParam, (String)"JJBZ", (String)"1");
            JDomUtils.addChild((Element)ReqParam, (String)"YOTU", (String)paymentInfo.getExplanation());
            StringBuilder signString = new StringBuilder();
            signString.append(serialNo).append("|");
            signString.append(date).append("|");
            signString.append(paymentInfo.getAccNo()).append("|");
            signString.append(paymentInfo.getAccName()).append("|");
            signString.append(paymentInfo.getIncomeAccNo()).append("|");
            signString.append(paymentInfo.getIncomeAccName()).append("|");
            signString.append(paymentInfo.getIncomeBankName()).append("|");
            if (BankBusinessConfig.isUseSM()) {
                signString.append(addres).append("|");
            }
            signString.append(paymentInfo.getIncomeCnaps()).append("|");
            signString.append(BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount())).append("|");
            signString.append(paymentInfo.getCurrency()).append("|");
            signString.append(ZZLX).append("|");
            signString.append("1").append("|");
            signString.append(paymentInfo.getExplanation()).append("|");
            Element signInfo = JDomUtils.addChild((Element)GZCBEBankData, (String)"signInfo");
            SignService signService = new SignService();
            JDomUtils.addChild((Element)signInfo, (String)"signed_data", (String)signService.sign(signString.toString()));
            Document document = new Document(GZCBEBankData);
            String xml = DomHelper.doc2StringPlain(document, RequestContextUtils.getCharset());
            String saq = GZCBEBankDataHelper.add(xml, sessionId, "srv007_singleOuterTransfer");
            try {
                this.contentLength = saq.getBytes(RequestContextUtils.getCharset()).length;
            }
            catch (UnsupportedEncodingException e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
            String string = saq;
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (EBServiceException e) {
                EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u91ca\u653e\u8bbf\u95ee\u7968\u5f02\u5e38\uff1a\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (Throwable)e).printStackTrace();
            }
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u666e\u901a\u4ed8\u6b3e\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = paymentInfos[0];
        String xml = GZCBEBankDataHelper.cut(rspStr, true);
        Element GZCBEBankData = JDomUtils.string2Root((String)xml, (String)RequestContextUtils.getCharset());
        Element opRep = DomHelper.getChildElementNotNull(GZCBEBankData, "opRep");
        String errMsg = DomHelper.getChildText(opRep, "errMsg");
        Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
        String JYZT = DomHelper.getChildTextNotNull(opResult, "JYZT", ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]));
        if (paymentInfo.is2SameBank()) {
            if ("90".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
            } else if ("91".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
            } else if ("99".equals(JYZT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
            }
        } else if ("91".equals(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
        } else if ("99".equals(JYZT) || "60".equals(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]), (String)JYZT, (String)errMsg);
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "srv006_singleInnerTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26 srv006_singleInnerTransfer\uff0c \u8de8\u884c\u6c47\u6b3e srv007_singleOuterTransfer\uff0c\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2 srv009_transferResultInfoQuery\u3002", (String)"PaymentImpl_8", (String)"ebg-aqap-banks-gzcb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        String encoding = RequestContextUtils.getCharset();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"uri"));
        factory.setHttpHeader("Content-Length", Integer.toString(this.contentLength));
        factory.setHttpHeader("Content-Type", "text/xml; charset=" + encoding);
    }
}

