/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractMT942Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.egf.common.codeless.PackerUtil.CodeLessUtil;
import kd.ebg.egf.common.codeless.ParserUtil.MapToObjectUtil;
import kd.ebg.egf.common.codeless.ParserUtil.ParseUtil;
import kd.ebg.egf.common.codeless.dateUtil.LocalDateTimeUtil;
import kd.ebg.egf.common.codeless.dateUtil.LocalDateUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.framework.service.codeless.CodeLessService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.codeless.CodeLess;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.io.FileUtils;

public abstract class AbstractCodelessCAMT052Handler
extends AbstractMT942Handler {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractCodelessCAMT052Handler.class);
    Map<String, String> currencyMap = new HashMap<String, String>(16);

    protected abstract String getBalanceBizCode();

    protected abstract String getDetailBizCode();

    protected abstract boolean isTodayFile(File var1);

    protected String getRealbankVersion() {
        return null;
    }

    @Override
    protected void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        HashMap param;
        CodeLess codeLess;
        String bankVersion;
        EBContext ebContext = EBContext.getContext();
        if (!StringUtils.isEmpty((String)this.getDetailBizCode())) {
            try {
                bankVersion = StringUtils.isEmpty((String)this.getRealbankVersion()) ? this.context.getBankVersionID() : this.getRealbankVersion();
                codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCodeAndApp(bankVersion, "queryDetail", this.getDetailBizCode(), "QUERY");
                ebContext.setCodeLess(codeLess);
                if (ebContext.getRunningParams() == null) {
                    param = new HashMap(1);
                    ebContext.setRunningParams(param);
                }
                this.processHisDetail(file, detailInfoList, payInfoList, balanceInfoList);
            }
            catch (Exception e) {
                logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u62a5\u544a[%1$s]\u51fa\u9519\u3002", (String)"AbstractCodelessCAMTHandler_1", (String)"ebg-aqap-proxy", (Object[])new Object[0]), file.getName()), (Throwable)e);
            }
        } else {
            this.processHisDetailNocodeless(file, detailInfoList, payInfoList, balanceInfoList);
        }
        if (!StringUtils.isEmpty((String)this.getBalanceBizCode())) {
            try {
                bankVersion = StringUtils.isEmpty((String)this.getRealbankVersion()) ? this.context.getBankVersionID() : this.getRealbankVersion();
                codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCodeAndApp(bankVersion, "queryBalance", this.getBalanceBizCode(), "QUERY");
                ebContext.setCodeLess(codeLess);
                if (ebContext.getRunningParams() == null) {
                    param = new HashMap(1);
                    ebContext.setRunningParams(param);
                }
                this.processHisBalance(file, detailInfoList, payInfoList, balanceInfoList);
            }
            catch (Exception e) {
                logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u62a5\u544a[%1$s]\u51fa\u9519\u3002", (String)"AbstractCodelessCAMTHandler_1", (String)"ebg-aqap-proxy", (Object[])new Object[0]), file.getName()), (Throwable)e);
            }
        } else {
            this.processHisBalanceNocodeless(file, detailInfoList, payInfoList, balanceInfoList);
        }
    }

    private void processHisDetailNocodeless(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
    }

    private void processHisDetail(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        List eachData = ParseUtil.getRepeaterDataWithAttr((String)this.getFromFile(file));
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        Map map = CodeLessUtil.getNeedParam();
        for (Map objectMap : eachData) {
            boolean isPasss = ParseUtil.isPassing((Map)objectMap, null);
            if (isPasss) continue;
            DetailInfo detail = new DetailInfo();
            AbstractCodelessCAMT052Handler.reloadData(detail, objectMap, map);
            Map jsonMap = (Map)objectMap.get("jsonMap");
            if (jsonMap != null) {
                String jsonString = JSON.toJSONString((Object)jsonMap);
                detail.setJsonMap(jsonString);
            }
            detail.setBankVersionID(this.context.getBankVersionID());
            detail.setCustomID(this.context.getCustomID());
            detailInfos.add(detail);
            if (!this.currencyMap.containsKey(detail.getCurrency())) {
                this.currencyMap.put(detail.getCurrency(), CurrencyUtils.convert2Iso((String)detail.getCurrency()));
            }
            String currency = this.currencyMap.get(detail.getCurrency());
            detail.setCurrency(currency);
            if (!AbstractCodelessCAMT052Handler.isDealPay()) continue;
            AbstractCodelessCAMT052Handler.dealPay(payInfoList, detail);
        }
        this.dealDetail(detailInfos);
    }

    static boolean isDealPay() {
        return false;
    }

    static void dealPay(List<PaymentInfo> payInfoList, DetailInfo detailInfo) {
        if (StringUtils.isNotEmpty((String)detailInfo.getKdFlag())) {
            try {
                PaymentInfo paymentInfo = OverseaDBHelper.getPaymentInfoByBankDetailSeqId(detailInfo.getKdFlag());
                if (paymentInfo != null) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"AbstractCodelessCAMTHandler_3", (String)"ebg-aqap-proxy", (Object[])new Object[0]), (String)"PAY_SUCCESS", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"AbstractCodelessCAMTHandler_3", (String)"ebg-aqap-proxy", (Object[])new Object[0]));
                    payInfoList.add(paymentInfo);
                }
            }
            catch (Exception e) {
                logger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u7684\u4ed8\u6b3e\u6570\u636e\u5931\u8d25\uff0c\u65e0\u6cd5\u66f4\u65b0\u4ed8\u6b3e\u72b6\u6001%1$s", (String)"AbstractCodelessCAMTHandler_4", (String)"ebg-aqap-proxy", (Object[])new Object[0]), e));
            }
        }
    }

    public static Map<String, List<DetailInfo>> groupByName_Stream(List<DetailInfo> students) {
        return students.stream().collect(Collectors.groupingBy(DetailInfo::getAccNo));
    }

    private void dealDetail(List<DetailInfo> detailInfos) {
        if (detailInfos.isEmpty()) {
            return;
        }
        Map<String, List<DetailInfo>> detailGroupMap = AbstractCodelessCAMT052Handler.groupByName_Stream(detailInfos);
        detailGroupMap.forEach((accno, detailInfoList) -> {
            if (StringUtils.isEmpty((String)accno)) {
                logger.info("\u8d26\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406");
                return;
            }
            BankAcnt bankAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accno, EBContext.getContext().getCustomID());
            if (bankAcnt == null) {
                logger.info("\u8d26\u53f7\u5728\u94f6\u4f01\u4e91\u672a\u7ef4\u62a4\uff0c\u65e0\u6cd5\u5904\u7406");
                return;
            }
            LocalDate minDate = detailInfoList.stream().map(DetailInfo::getTransDate).min(LocalDate::compareTo).orElse(null);
            LocalDate maxDate = detailInfoList.stream().map(DetailInfo::getTransDate).max(LocalDate::compareTo).orElse(null);
            DetailInfoService.getInstance().insertOrUpdate(detailInfoList, bankAcnt, EBContext.getContext().getCustomID(), minDate, maxDate);
        });
    }

    private void processHisBalanceNocodeless(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
    }

    private void processHisBalance(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws Exception {
        List eachData = ParseUtil.getRepeaterDataWithAttr((String)this.getFromFile(file));
        Map map = CodeLessUtil.getNeedParam();
        for (Map objectMap : eachData) {
            boolean isPasss = ParseUtil.isPassing((Map)objectMap, null);
            if (isPasss) continue;
            OverseaBalance detail = new OverseaBalance();
            AbstractCodelessCAMT052Handler.reloadData(detail, objectMap, map);
            detail.setBankVersion(EBContext.getContext().getBankVersionID());
            detail.setUpdateSource(file.getName());
            detail.setBalanceDate(LocalDateTime.now());
            balanceInfoList.add(detail);
        }
        AbstractCodelessCAMT052Handler.dealBalance(balanceInfoList);
    }

    public static void dealBalance(List<OverseaBalance> balanceInfoList) {
    }

    protected String getFromFile(File file) throws Exception {
        String fileContent = FileUtils.readFileToString((File)file, (String)this.getEncoding());
        fileContent = fileContent.replace("\ufeff", "");
        return fileContent;
    }

    private String getEncoding() {
        return "UTF-8";
    }

    private static OverseaBalance reloadData(OverseaBalance balanceInfo, Map eachData, Map reflect) throws Exception {
        Map result = MapToObjectUtil.coventMap((Map)eachData, (Map)reflect);
        Map judge = ParseUtil.getParseResultMap((Map)eachData, null);
        result.putAll(judge);
        AbstractCodelessCAMT052Handler.reloadData(balanceInfo, result);
        return balanceInfo;
    }

    private static OverseaBalance reloadData(OverseaBalance balanceInfo, Map eachData) {
        Set set2 = eachData.keySet();
        set2.stream().forEach(key -> {
            String value;
            if ("currentBalance".equals(key)) {
                String value2 = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value2)) {
                    balanceInfo.setCurrentBalance(new BigDecimal(value2));
                }
            } else if ("availableBalance".equals(key)) {
                String value3 = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value3)) {
                    balanceInfo.setAvailableBalance(new BigDecimal(value3));
                }
            } else if ("balanceDateTime".equals(key)) {
                String value4 = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value4)) {
                    value4 = value4.replaceAll("-", "");
                    DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE;
                    balanceInfo.setBalanceDate(LocalDateTimeUtil.tryParse((String)value4));
                }
            } else if ("accNo".equals(key)) {
                String value5 = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value5)) {
                    balanceInfo.setNumber(value5);
                }
            } else if ("currency".equals(key) && !StringUtils.isEmpty((String)(value = (String)eachData.get(key)))) {
                balanceInfo.setCurrency(value);
            }
        });
        return balanceInfo;
    }

    private static DetailInfo reloadData(DetailInfo detailInfo, Map eachData, Map reflect) throws Exception {
        Map result = MapToObjectUtil.coventMap((Map)eachData, (Map)reflect);
        Map judge = ParseUtil.getParseResultMap((Map)eachData, null);
        result.putAll(judge);
        AbstractCodelessCAMT052Handler.reloadData(detailInfo, result);
        return detailInfo;
    }

    private static DetailInfo reloadData(DetailInfo detailInfo, Map eachData) {
        Set set2 = eachData.keySet();
        set2.stream().forEach(key -> {
            if ("debitAmount".equals(key)) {
                String value = (String)eachData.get(key);
                if (StringUtils.isEmpty((String)value)) {
                    detailInfo.setDebitAmount(new BigDecimal("0"));
                } else {
                    detailInfo.setDebitAmount(new BigDecimal(value));
                }
            } else if ("creditAmount".equals(key)) {
                String value = (String)eachData.get(key);
                if (StringUtils.isEmpty((String)value)) {
                    detailInfo.setCreditAmount(new BigDecimal("0"));
                } else {
                    detailInfo.setCreditAmount(new BigDecimal(value));
                }
            } else if ("accNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setAccNo(value);
            } else if ("bankName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setBankName(value);
            } else if ("currency".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setCurrency(value);
            } else if ("oppAccNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setOppAccNo(value);
            } else if ("oppBankName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setOppBankName(value);
            } else if ("oppAccName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setOppAccName(value);
            } else if ("balance".equals(key)) {
                String value = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value)) {
                    detailInfo.setBalance(new BigDecimal(value));
                }
            } else if ("transDate".equals(key)) {
                String value = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value)) {
                    value = value.replaceAll("-", "");
                    detailInfo.setTransDate(LocalDateUtil.tryParse((String)value));
                }
            } else if ("detailDateTime".equals(key)) {
                String value = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value)) {
                    value = value.replaceAll("-", "");
                    detailInfo.setTransTime(LocalDateTimeUtil.tryParse((String)value));
                }
            } else if ("bankDetailNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setBankDetailNo(value);
            } else if ("bizRefNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setBizRefNo(value);
            } else if ("agentAccNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setAgentAccNo(value);
            } else if ("agentAccName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setAgentAccName(value);
            } else if ("agentAccBankName".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setAgentAccBankName(value);
            } else if ("vouhNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setVouhNo(value);
            } else if ("payBankDetailSeqID".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setPayBankDetailSeqID(value);
            } else if ("receiptNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setReceiptNo(value);
            } else if ("transferCharge".equals(key)) {
                String value = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value)) {
                    detailInfo.setTransferCharge(new BigDecimal(value));
                }
            } else if ("extraAccNo".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setExtraAccNo(value);
            } else if ("frmcod".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setFrmcod(value);
            } else if ("kdFlag".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setKdFlag(value);
            } else if ("explanation".equals(key)) {
                String value = (String)eachData.get(key);
                detailInfo.setExplanation(value);
            }
        });
        return detailInfo;
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }
}

