/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.oversea;

import java.io.File;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class BankFile
implements Comparable<BankFile> {
    private File file;
    volatile long lastModifiedTime;
    volatile long lastProcessedTime;
    volatile AtomicInteger processedCount;

    public BankFile(File file) {
        this.file = file;
        this.lastModifiedTime = file.lastModified();
    }

    public static BankFile transform(File file) {
        return new BankFile(file);
    }

    public void markProcessing() {
        this.lastProcessedTime = new Date().getTime();
        this.processedCount.incrementAndGet();
    }

    public File get() {
        return this.file;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.file.equals(((BankFile)obj).file);
    }

    @Override
    public int compareTo(BankFile o) {
        if (o == null) {
            return 0;
        }
        int comparedCount = this.processedCount.intValue() - o.processedCount.intValue();
        if (comparedCount != 0) {
            return comparedCount;
        }
        long t = this.lastModifiedTime - o.lastModifiedTime;
        if (t > 0L) {
            return 1;
        }
        if (t < 0L) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.file.getPath();
    }
}

