/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.proxy.swift.utils;

import java.util.ArrayList;
import java.util.List;
import kd.ebg.aqap.proxy.swift.model.Tag;

public class SwiftTagsUtils {
    public static int findIndex(List tags, int startPosition, String tagName) {
        int index = -1;
        for (int i = startPosition; i < tags.size(); ++i) {
            if (!((Tag)tags.get(i)).getTagName().equals(tagName)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int getTagsCount(List tags, String tagName) {
        int count = 0;
        if (null == tags || 0 == tags.size() || null == tagName || 0 == tagName.length()) {
            return 0;
        }
        for (int i = 0; i < tags.size(); ++i) {
            if (!((Tag)tags.get(i)).getTagName().equalsIgnoreCase(tagName)) continue;
            ++count;
        }
        return count;
    }

    public static int[] getTagsIndex(List tags, String tagName) {
        int[] indexs = new int[SwiftTagsUtils.getTagsCount(tags, tagName)];
        if (0 == indexs.length) {
            return indexs;
        }
        int index = 0;
        if (tags == null) {
            return new int[0];
        }
        for (int i = 0; i < tags.size(); ++i) {
            if (!((Tag)tags.get(i)).getTagName().equalsIgnoreCase(tagName)) continue;
            indexs[index++] = i;
        }
        return indexs;
    }

    public static List getTagsBetween(List tags, int startIndex, String startTagName, String endTagName) {
        List result = new ArrayList();
        int start = startIndex;
        int end = startIndex;
        boolean startFounded = false;
        boolean endFounded = false;
        for (int i = start; i < tags.size(); ++i) {
            if (!startFounded && ((Tag)tags.get(i)).getTagName().equals(startTagName)) {
                start = i;
                startFounded = true;
            }
            if (!endFounded && ((Tag)tags.get(i)).getTagName().equals(endTagName)) {
                end = i;
                endFounded = true;
            }
            if (startFounded && endFounded) break;
        }
        if (start <= end && end < tags.size()) {
            result = tags.subList(start, end + 1);
        }
        return result;
    }

    public static Tag getTagBetween(List tags, String tagName, int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < 0 || startIndex > endIndex) {
            return null;
        }
        int[] tagsIndex = SwiftTagsUtils.getTagsIndex(tags, tagName);
        if (0 == tagsIndex.length) {
            return null;
        }
        Tag tag = null;
        for (int i = 0; i < tagsIndex.length; ++i) {
            if (tagsIndex[i] < startIndex || tagsIndex[i] > endIndex) continue;
            tag = (Tag)tags.get(tagsIndex[i]);
            break;
        }
        return tag;
    }
}

