/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.opa.services.apply;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.opa.utils.CommonUtil;
import kd.ebg.aqap.business.apply.atomic.AbstractApplyImpl;
import kd.ebg.aqap.business.apply.atomic.IApply;
import kd.ebg.aqap.business.apply.bank.BankApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankApplyResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ApplyImpl
extends AbstractApplyImpl
implements IApply {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(ApplyImpl.class);

    public EBBankApplyResponse doBiz(BankApplyRequest request) {
        EBBankApplyResponse result;
        try {
            String requestStr = this.pack(request);
            Preconditions.checkNotNull((Object)requestStr, (Object)ResManager.loadKDString((String)"\u6253\u5305\u540e\u5f85\u53d1\u9001\u7684\u6570\u636e\u4e0d\u80fd\u4e3anull", (String)"ApplyImpl_0", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]));
            String responseStr = new CommonUtil().sendToBank(this.getBizCode(), requestStr);
            result = this.parse(request, responseStr);
        }
        catch (Exception var14) {
            String name = ResManager.loadKDString((String)"\u7b7e\u7ea6\u7533\u8bf7", (String)"ApplyImpl_1", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
            if ("D".equals(request.getApplyType())) {
                name = ResManager.loadKDString((String)"\u7b7e\u7ea6\u89e3\u9664", (String)"ApplyImpl_2", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
            }
            this.logger.error(name + "\u5931\u8d25", (Throwable)var14);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"ApplyImpl_3", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]), name), (Throwable)var14);
        }
        return result;
    }

    public String pack(BankApplyRequest request) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("serialNo", (Object)Sequence.gen18Sequence());
        String businessType = "1";
        String businessName = ResManager.loadKDString((String)"\u5f00\u901a", (String)"ApplyImpl_4", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
        if ("D".equals(request.getApplyType())) {
            businessType = "2";
            businessName = ResManager.loadKDString((String)"\u89e3\u9664", (String)"ApplyImpl_5", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
        }
        jsonObject.put("businessType", (Object)businessType);
        jsonObject.put("cid", (Object)EBContext.getContext().getParameter().getBankParameter("cust_no"));
        jsonObject.put("accountType", (Object)"1");
        JSONArray accountList = new JSONArray();
        jsonObject.put("accountList", (Object)accountList);
        JSONObject account = new JSONObject();
        accountList.add((Object)account);
        account.put("accountNo", (Object)request.getAcnt().getAccNo());
        account.put("accountName", (Object)request.getAcnt().getAccName());
        String bsnStr = request.getBsnStr();
        if (StringUtils.isEmpty((String)bsnStr)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981%s\u7684\u529f\u80fd", (String)"ApplyImpl_6", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]), businessName));
        }
        String[] bsnArray = bsnStr.split(",");
        JSONArray apiList = new JSONArray();
        account.put("apiList", (Object)apiList);
        for (int i = 0; i < bsnArray.length; ++i) {
            String apiNo = bsnArray[i];
            if (!StringUtils.isNotEmpty((String)apiNo)) continue;
            JSONObject api = new JSONObject();
            api.put("apiNo", (Object)apiNo);
            apiList.add((Object)api);
        }
        return jsonObject.toString();
    }

    public EBBankApplyResponse parse(BankApplyRequest request, String responseStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        String code = jsonObject.getString("code");
        String msg = jsonObject.getString("msg");
        if (!"0".equals(code)) {
            throw EBExceiptionUtil.serviceException((String)msg);
        }
        String resultCode = jsonObject.getString("resultCode");
        String resultMsg = jsonObject.getString("resultMsg");
        if (!"1".equals(resultCode)) {
            throw EBExceiptionUtil.serviceException((String)resultMsg);
        }
        String serialNo = jsonObject.getString("serialNo");
        return new EBBankApplyResponse(serialNo);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "/api/dcfirmSAAS/signSaasContract";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7b7e\u7ea6/\u89e3\u7ea6", (String)"ApplyImpl_8", (String)"ebg-aqap-banks-cib-opa", (Object[])new Object[0]);
    }
}

