/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.opa.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class CIBCertificateUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CIBCertificateUtil.class);
    private static String FILE_DIR = "cibopa";
    private static String PUBLIC_FILE_NAME = "cibPublic.cer";
    private static String PRIVATE_FILE_NAME = "cibPrivate.sm2";
    private static String BANK_VERSION_ID = "CIB_OPA";
    private static String CERT_PRIVATE_KEY = "plateForm_private_certInfo";
    private static String CERT_PUBLIC_KEY = "plateForm_public_certInfo";

    private CIBCertificateUtil() {
    }

    private static String getPlatePrivateSM2() {
        return CIBCertificateUtil.getPlateCertInfo(CERT_PRIVATE_KEY);
    }

    private static String getPlatePublicCer() {
        return CIBCertificateUtil.getPlateCertInfo(CERT_PUBLIC_KEY);
    }

    public static String getPlateCertInfo(String key) {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(BANK_VERSION_ID, key);
        if (certInfo == null) {
            return "";
        }
        CipherInfo cipherInfo = CIBCertificateUtil.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return new String(fileContent);
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    public static void checkOrCreateFile(boolean isNeedCheckExist) {
        CIBCertificateUtil.saveAsFileWriter(PUBLIC_FILE_NAME, CIBCertificateUtil.getPlatePublicCer(), isNeedCheckExist);
        CIBCertificateUtil.saveAsFileWriter(PRIVATE_FILE_NAME, CIBCertificateUtil.getPlatePrivateSM2(), isNeedCheckExist);
    }

    private static String saveAsFileWriter(String fileName, String content, boolean isNeedCheckExist) {
        String dir = "";
        if (StringUtils.isEmpty((String)content)) {
            return dir;
        }
        String fileDir = System.getProperty("user.dir") + File.separator + FILE_DIR;
        File file = new File(FileCommonUtils.checkPath((String)fileDir));
        if (!file.exists()) {
            file.mkdir();
        }
        dir = fileDir + File.separator + fileName;
        File fileCer = new File(FileCommonUtils.checkPath((String)dir));
        if (isNeedCheckExist && fileCer.exists()) {
            logger.info(String.format("\u5174\u4e1a\u6587\u4ef6\u5df2\u5b58\u5728\uff1a%s", dir));
            return dir;
        }
        try (FileWriter fileWriter = new FileWriter(FileCommonUtils.checkPath((String)dir));){
            fileWriter.write(content);
        }
        catch (IOException ex) {
            dir = "";
        }
        logger.info(String.format("\u5174\u4e1a\u65b0\u521b\u5efa\u6587\u4ef6\uff1a%s", dir));
        return dir;
    }

    public static String getPublicFileDir() {
        String fileDir = String.format("%s%s%s%s%s", System.getProperty("user.dir"), File.separator, FILE_DIR, File.separator, PUBLIC_FILE_NAME);
        File file = new File(FileCommonUtils.checkPath((String)fileDir));
        if (file.exists()) {
            return fileDir;
        }
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        CertInfo certInfo = certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(BANK_VERSION_ID, CERT_PUBLIC_KEY);
        if (certInfo == null) {
            return "";
        }
        CipherInfo cipherInfo = CIBCertificateUtil.getCipherInfo(certInfo.getFileContent());
        byte[] byteContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String strContent = new String(byteContent);
        return CIBCertificateUtil.saveAsFileWriter(PUBLIC_FILE_NAME, strContent, false);
    }

    public static CertInfo getPrivateCertInfo() {
        CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);
        return certRepository.findPlateFormCertByBankVersionIDAndBankConfigID(BANK_VERSION_ID, CERT_PRIVATE_KEY);
    }

    public static String getPrivateFileDir(CertInfo certInfo) {
        String fileDir = String.format("%s%s%s%s%s", System.getProperty("user.dir"), File.separator, FILE_DIR, File.separator, PRIVATE_FILE_NAME);
        File file = new File(FileCommonUtils.checkPath((String)fileDir));
        if (file.exists()) {
            return fileDir;
        }
        if (certInfo == null) {
            return "";
        }
        CipherInfo cipherInfo = CIBCertificateUtil.getCipherInfo(certInfo.getFileContent());
        byte[] byteContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        String strContent = new String(byteContent);
        return CIBCertificateUtil.saveAsFileWriter(PRIVATE_FILE_NAME, strContent, false);
    }
}

