/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.opa.sign;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kd.ebg.aqap.banks.pab.opa.sign.Exception.ErrorInfo;
import kd.ebg.aqap.banks.pab.opa.sign.util.StringTool;
import kd.ebg.egf.common.log.EBGLogger;

public class Config {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(Config.class);
    public static final String DEFAULT_HASHALG = "SHA1";
    private String configDir;
    private String signMode;
    private String certDn;
    private String verifySignMode;
    private String hashAlg;
    private String caCertPath;
    private String crlPath;
    private String pfxPath;
    private String pfxPwd;
    private boolean checkBankSign;
    private Set<String> bankCertDN = new HashSet<String>();
    private boolean fieldEncry;
    private static Config instance = new Config();

    public static Config getInstance() {
        return instance;
    }

    public Config() {
        try {
            log.info("\u914d\u7f6e\u521d\u59cb\u5316...");
            this.configDir = System.getProperty("user.dir") + File.separator + "configuration" + File.separator;
            ErrorInfo info = new ErrorInfo();
            this.initSignCfg();
            try {
                StringBuilder sb = StringTool.printObject(this, Config.class);
                log.info("read Config:{}", (Object)sb.toString());
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            log.info("\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u7ed3\u675f\u3002");
        }
        catch (NoSuchElementException e) {
            log.error("\u914d\u7f6e\u9879\u672a\u8bbe\u7f6e\u6216\u503c\u4e3a\u7a7a\uff1a" + e.getMessage());
            throw e;
        }
    }

    private void initSignCfg() {
        this.fieldEncry = true;
        this.hashAlg = DEFAULT_HASHALG;
        this.signMode = "RSA_SOFT";
        this.certDn = "";
        this.verifySignMode = "RSA_SOFT";
        this.caCertPath = null;
        this.crlPath = null;
        this.checkBankSign = true;
        String dn = null;
        if (dn != null) {
            String[] dnarr = Config.split(dn, ';');
            for (int i = 0; i < dnarr.length; ++i) {
                String s = dnarr[i].trim();
                if (s.length() <= 0) continue;
                this.bankCertDN.add(s);
            }
        }
    }

    public static String[] split(String src, char c) {
        String last;
        ArrayList<String> lst = new ArrayList<String>(16);
        char[] chars = src.toCharArray();
        StringBuilder sb = new StringBuilder(src.length());
        for (int p = 0; p < chars.length; ++p) {
            if (chars[p] != c) {
                sb.append(chars[p]);
                continue;
            }
            if (p + 1 == chars.length) break;
            if (chars[p + 1] != c) {
                lst.add(sb.toString().trim());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
            ++p;
        }
        if ((last = sb.toString().trim()).length() != 0) {
            lst.add(last);
        }
        return lst.toArray(new String[0]);
    }

    public String getHashAlg() {
        return this.hashAlg;
    }

    public String getSignMode() {
        return this.signMode;
    }

    public String getCertDn() {
        return this.certDn;
    }

    public String getCaCertPath() {
        return this.caCertPath;
    }

    public String getCrlPath() {
        return this.crlPath;
    }

    public String getPfxPath() {
        return this.pfxPath;
    }

    public String getPfxPwd() {
        return this.pfxPwd;
    }

    public Set<String> getBankCertDN() {
        return this.bankCertDN;
    }

    public boolean isCheckBankSign() {
        return this.checkBankSign;
    }
}

