/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.dc.services.balance;

import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Packer;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        Element root = ZSB_DC_Packer.buildHead("200114", RequestContextUtils.getRequestContext().getBankRequestSeq());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        Element record = JDomUtils.addChild((Element)body, (String)"record");
        JDomUtils.addChild((Element)record, (String)"date", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)record, (String)"accno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)record, (String)"cur_code", (String)request.getBankCurrency());
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return ZSB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ZSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element body = root.getChild("body");
        List balanceList = body.getChildren("record");
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        for (Element balanceInfo : balanceList) {
            BalanceInfo info = new BalanceInfo();
            this.setCurrentBalance(info, balanceInfo.getChildTextTrim("balance"));
            String bankCurrency = balanceInfo.getChildTextTrim("cur_code");
            this.setBankAcnt(info, request.getBankAcntList(), balanceInfo.getChildTextTrim("accno"));
            this.setBankCurrency(info, bankCurrency);
            String date = balanceInfo.getChildTextTrim("date");
            this.setBalanceDateTime(info, date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            balanceInfos.add(info);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "200114";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"200114(\u5386\u53f2\u4f59\u989d)", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return ZSB_DC_Parser.parseRecvMsg(super.recv(inputStream));
    }

    public int queryDays() {
        return 1;
    }
}

