/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Packer;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Parser;
import kd.ebg.aqap.banks.zsb.dc.services.detail.ResponseFileUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    public static final String EXPLANATION_PREFIX = "KD@";
    public static final int PAGE_SIZE = 10;
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest rqst) {
        Element root = ZSB_DC_Packer.buildHead("200112", Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)rqst.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)rqst.getBankCurrency());
        if (this.checkDate(rqst.getStartDate(), rqst.getEndDate())) {
            JDomUtils.addChild((Element)body, (String)"start_date", (String)rqst.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)body, (String)"end_date", (String)rqst.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            String[] strings = StringUtils.split((String)this.getZSBCurrentPage(), (String)"|");
            String pageNum = strings[0];
            JDomUtils.addChild((Element)body, (String)"pageno", (String)pageNum);
            Element totalfilename = JDomUtils.addChild((Element)body, (String)"totalfilename");
            if (Integer.parseInt(pageNum) > 1) {
                String totalfilenameString = strings[1];
                totalfilename.setText(totalfilenameString);
            }
            JDomUtils.addChild((Element)body, (String)"isbal", (String)"1");
            String encoding = RequestContextUtils.getCharset();
            String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
            return ZSB_DC_Packer.buildCommonMsg(xmlStr);
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u95f4\u9694\u4e0d\u80fd\u8d85\u8fc7\u4e09\u4e2a\u6708\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]));
    }

    private boolean checkDate(LocalDate sDate, LocalDate eDate) {
        Calendar sCalendar = Calendar.getInstance();
        Calendar eCalendar = Calendar.getInstance();
        sCalendar.setTime(DetailImpl.LocalDateToDate(sDate));
        eCalendar.setTime(DetailImpl.LocalDateToDate(eDate));
        int result = eCalendar.get(2) - sCalendar.get(2);
        int month = (eCalendar.get(1) - sCalendar.get(1)) * 12;
        return result + month <= 3;
    }

    public static Date LocalDateToDate(LocalDate localDate) {
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        String[] splits;
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        this.dealPage(rspStr);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = ZSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0:%1$s, %2$s", (String)"DetailImpl_12", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        this.logger.info("\u4ea4\u6613\u660e\u7ec6\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equalsIgnoreCase(record_num)) {
            return new EBBankDetailResponse(detailList);
        }
        if ("1".equalsIgnoreCase(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            splits = ResponseFileUtils.getDetailRspRecords(file_name);
        } else if ("0".equalsIgnoreCase(file_flag)) {
            String serial_record = body.getChildTextTrim("serial_record");
            splits = StringUtils.split((String)serial_record, (String)"|");
        } else {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\u3002\u539f\u56e0\uff1a\u94f6\u884c\u8fd4\u56de\u7684file_flag\u5b57\u6bb5\u4e0d\u6b63\u786e\uff0c\u5bfc\u81f4\u94f6\u4f01\u4e91\u65e0\u6cd5\u83b7\u53d6\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]));
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 1; i <= recordNum; ++i) {
            String serial_no = splits[fieldNum * i + 0];
            String crdr_flag = splits[fieldNum * i + 2];
            String acno = splits[fieldNum * i + 3];
            String acname = splits[fieldNum * i + 4];
            String oppAcntNumber = splits[fieldNum * i + 7];
            String oppName = splits[fieldNum * i + 8];
            String oppBank = splits[fieldNum * i + 10];
            String cur_code = splits[fieldNum * i + 11];
            String amt = splits[fieldNum * i + 12];
            String tr_acdt = splits[fieldNum * i + 13];
            String tr_time = splits[fieldNum * i + 14];
            String sumcode = splits[fieldNum * i + 16];
            String purpose = splits[fieldNum * i + 18];
            String postscript = splits[fieldNum * i + 19];
            String remark = splits[fieldNum * i + 20];
            String balance = splits[fieldNum * i + 22];
            if (!rqst.getAcnt().getAccNo().equals(acno)) {
                this.logger.info("===\u8bf7\u6c42\u8d26\u53f7[" + rqst.getAcnt().getAccNo() + "]\u548c\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[" + acno + "]\u4e0d\u4e00\u81f4\uff0c\u88ab\u8fc7\u6ee4\u7684\u660e\u7ec6===");
                continue;
            }
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acno);
            detail.setAccName(acname);
            detail.setOppAccNo(oppAcntNumber);
            detail.setOppAccName(oppName);
            detail.setOppBankName(oppBank);
            if (!StringUtils.isEmpty((String)postscript) && postscript.contains(EXPLANATION_PREFIX)) {
                String postscriptInfo = postscript;
                String bankDetailSeqId = postscript.substring(0, postscript.indexOf(EXPLANATION_PREFIX));
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                if (postscriptInfo.indexOf("trans_up") != -1) {
                    postscript = postscript.replace("trans_up", "");
                    DetailSysFiled.set((DetailInfo)detail, (String)"trans_up", (String)"TRUE");
                }
                postscript = postscript.substring(bankDetailSeqId.length() + EXPLANATION_PREFIX.length());
                detail.setExplanation(postscript);
            }
            if (PropertiesConstants.getValue((String)"SERVICE_CHARGE").equalsIgnoreCase(sumcode)) {
                DetailSysFiled.delete((DetailInfo)detail, (String)"KDRetFlag");
            }
            detail.setCurrency(cur_code);
            try {
                if (StringUtils.isEmpty((String)tr_acdt) || StringUtils.isEmpty((String)tr_time)) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]));
                }
                detail.setTransDate(LocalDate.parse(tr_acdt, DateTimeFormatter.ofPattern("yyyyMMdd")));
                detail.setTransTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38.%s", (String)"DetailImpl_13", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            if ("1".equalsIgnoreCase(crdr_flag)) {
                detail.setDebitAmount(new BigDecimal(amt));
                detail.setCreditAmount(new BigDecimal("0"));
            } else if ("2".equalsIgnoreCase(crdr_flag)) {
                detail.setDebitAmount(new BigDecimal("0"));
                detail.setCreditAmount(new BigDecimal(amt));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u6807\u5fd7crdr_flag\u4e3a%s\uff0c\u671f\u5f85\u8fd4\u56de1\u6216\u80052\u3002", (String)"DetailImpl_14", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), crdr_flag));
            }
            String explanation = String.format(ResManager.loadKDString((String)"\u6458\u8981:%1$s\u7528\u9014:%2$s|\u9644\u8a00:%3$s|\u5907\u6ce8:%4$s\u3002", (String)"DetailImpl_15", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), sumcode, purpose, postscript, remark);
            detail.setExplanation(explanation);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("serialNo", (Object)serial_no);
            jsonObject.put("tr_acdt", (Object)tr_acdt);
            jsonObject.put("serial_no", (Object)serial_no);
            jsonObject.put("summary", (Object)sumcode);
            jsonObject.put("sumcode", (Object)sumcode);
            jsonObject.put("purpose", (Object)purpose);
            jsonObject.put("postscript", (Object)postscript);
            jsonObject.put("remark", (Object)remark);
            jsonObject.put("memo", (Object)remark);
            String accNo = rqst.getAcnt().getAccNo();
            String transDate = tr_acdt;
            String jsonStr = jsonObject.toJSONString();
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setJsonMap(jsonStr);
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(serial_no);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getZSBCurrentPage() {
        String pageTag = this.getCurrentPage();
        if ("0".equalsIgnoreCase(pageTag)) {
            pageTag = "1|";
        }
        return pageTag;
    }

    private void dealPage(String rspStr) {
        String pageTag = this.getZSBCurrentPage();
        this.setCurrentPage(this.getNextPageTag(rspStr, pageTag));
        this.setLastPage(this.isLastPage(rspStr, pageTag));
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        String[] strings = StringUtils.split((String)pageTag, (String)"|");
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = root.getChild("body");
        String totalfilename = body.getChildTextTrim("totalfilename");
        String pageNum = String.valueOf(Integer.parseInt(strings[0]) + 1);
        return pageNum.concat("|").concat(totalfilename);
    }

    private boolean isLastPage(String rspStr, String pageTag) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String total_record_num = body.getChildTextTrim("total_record_num");
        Integer intRecord_num = Integer.parseInt(record_num);
        Integer intTotal_record_num = Integer.parseInt(total_record_num);
        String[] strings = StringUtils.split((String)pageTag, (String)"|");
        String pageNum = strings[0];
        Integer intPageTag = Integer.parseInt(pageNum);
        if (intRecord_num < 10) {
            return true;
        }
        return (intPageTag - 1) * 10 == intTotal_record_num;
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "200112";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_11", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return ZSB_DC_Parser.parseRecvMsg(super.recv(inputStream));
    }

    public boolean isSupportPage() {
        return true;
    }
}

