/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cbhb.dc.services;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.ebg.aqap.banks.cbhb.dc.BankBusinessConfig;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;

public class Utils {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(Utils.class);

    public static PaymentInfo[] listToArray(List<PaymentInfo> list) {
        List<PaymentInfo> paymentInfolist = list;
        PaymentInfo[] paymentInfos = new PaymentInfo[paymentInfolist.size()];
        return paymentInfolist.toArray(paymentInfos);
    }

    public static String convJsonDateToString(String jsonDate, String stringTemplate) {
        String resultString = null;
        try {
            Calendar cldCalendar = Utils.convToCalender(jsonDate, stringTemplate);
            resultString = Utils.convToString(cldCalendar, stringTemplate);
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        return resultString;
    }

    public static Calendar convToCalender(String str, String template) {
        Calendar cltResult = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(template, Locale.getDefault());
        try {
            Date date = sdf.parse(str);
            cltResult.setTime(date);
        }
        catch (Exception ex) {
            logger.info(ex.toString());
        }
        return cltResult;
    }

    public static String convToString(Calendar cld, String template) {
        String resultString = null;
        try {
            Date date = cld.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat(template, Locale.getDefault());
            resultString = sdf.format(date);
        }
        catch (Exception e) {
            logger.info(e.toString());
        }
        return resultString;
    }

    public static String getExplanationForSalary(PaymentInfo info) {
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
            return BizNoUtil.cont((String)info.getBankDetailSeqId(), (String)info.getExplanation());
        }
        return info.getExplanation();
    }
}

