/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sde.dc.services.detail;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sde.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.sde.dc.utils.SDEPackerUtils;
import kd.ebg.aqap.banks.sde.dc.utils.SDEParserUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest request) {
        Element root = SDEPackerUtils.createRootWithHead(request.getHeader().getRequestSeqID(), "B2EActTrsQry");
        Element Body = JDomUtils.addChild((Element)root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)Body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"Currency", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)Map2, (String)"BeginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Map2, (String)"EndDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return JDomUtils.root2String((Element)root, (String)"GBK");
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        Element root = SDEParserUtils.parseRspToRoot(responseStr);
        BankResponse rsp = SDEParserUtils.parseResponse(root);
        if (!"000000".equals(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_15", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element Body = JDomUtils.getChildElementNotNull((Element)root, (String)"Body");
        Element List2 = JDomUtils.getChildElement((Element)Body, (String)"List");
        Element Map2 = JDomUtils.getChildElement((Element)List2, (String)"Map");
        String ReturnCode = JDomUtils.getChildTextNotNull((Element)Map2, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u8fd4\u56de\u72b6\u6001\u7801", (String)"DetailImpl_2", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
        if (this.isNoDetailCode(ReturnCode)) {
            return new EBBankDetailResponse(new ArrayList(1));
        }
        this.checkDetailRsp(request, Map2);
        List mapList = Map2.getChildren("Map");
        if (null == mapList || mapList.size() == 0) {
            this.log.error("\u8fd4\u56de\u4ea4\u6613\u660e\u7ec6\u62a5\u6587\u4e2d\u4e0d\u5b58\u5728\u8282\u70b9<Message/Body/List/Map/Map>");
            return new EBBankDetailResponse(new ArrayList(1));
        }
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 0; i < mapList.size(); ++i) {
            Element map = (Element)mapList.get(i);
            detailList.add(this.parseSingleDetal(request, map, countMap));
        }
        return new EBBankDetailResponse(detailList);
    }

    private boolean isNoDetailCode(String returnCode) {
        if (StringUtils.isEmpty((String)returnCode)) {
            return false;
        }
        List<String> codes = BankBusinessConfig.getNoDetailCodes();
        for (int i = 0; i < codes.size(); ++i) {
            if (!codes.get(i).equalsIgnoreCase(returnCode)) continue;
            return true;
        }
        return false;
    }

    private void checkDetailRsp(BankDetailRequest rqst, Element Map2) {
        String ReturnCode = JDomUtils.getChildTextNotNull((Element)Map2, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u8fd4\u56de\u72b6\u6001\u7801", (String)"DetailImpl_2", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
        String ReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Map2, (String)"ReturnMsg");
        String AcNo = JDomUtils.getChildTextNotNull((Element)Map2, (String)"AcNo", (String)ResManager.loadKDString((String)"\u5e10\u53f7", (String)"DetailImpl_3", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
        if (!"000000".equals(ReturnCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u94f6\u884c\u8fd4\u56de\u7801:%1$s\uff0c\u9519\u8bef\u4fe1\u606f:%2$s\u3002", (String)"DetailImpl_15", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        if (!AcNo.equals(rqst.getAcnt().getAccNo())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u8fd4\u56de\u8d26\u53f7[%1$s]\u548c\u8bf7\u6c42\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"DetailImpl_16", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), AcNo, rqst.getAcnt().getAccNo());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
    }

    private DetailInfo parseSingleDetal(BankDetailRequest rqst, Element map, Map<String, Integer> countMap) {
        LocalDateTime transTime;
        LocalDate transDate;
        String Currency = JDomUtils.getChildTextNullAsBlank((Element)map, (String)"Currency");
        String Balance = JDomUtils.getChildTextNullAsBlank((Element)map, (String)"Balance");
        String Remark = JDomUtils.getChildTextNullAsBlank((Element)map, (String)"Remark");
        String PayeeAcNo = JDomUtils.getChildTextNullAsBlank((Element)map, (String)"PayeeAcNo");
        String PayeeAcName = JDomUtils.getChildTextNullAsBlank((Element)map, (String)"PayeeAcName");
        String PayeeAcBankName = JDomUtils.getChildTextNullAsBlank((Element)map, (String)"PayeeAcBankName");
        DetailInfo detail = new DetailInfo();
        detail.setAccNo(rqst.getAcnt().getAccNo());
        detail.setAccName(rqst.getAcnt().getAccName());
        detail.setCurrency(Currency);
        String TransJnlDate = JDomUtils.getChildTextNotNull((Element)map, (String)"TransJnlDate", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u65e5\u671f", (String)"DetailImpl_7", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
        String StandbyOne = JDomUtils.getChildTextNotNull((Element)map, (String)"StandbyOne", (String)ResManager.loadKDString((String)"\u5907\u75281", (String)"DetailImpl_8", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
        if (StringUtils.isEmpty((String)StandbyOne)) {
            StandbyOne = "00:00:00";
        }
        try {
            transDate = LocalDate.parse(TransJnlDate, DateTimeFormatter.ofPattern("yyyyMMdd"));
            transTime = LocalDateTime.parse(TransJnlDate + StandbyOne, DateTimeFormatter.ofPattern("yyyyMMddHH:mm:ss"));
        }
        catch (Exception e) {
            String errorMsg = ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u671f\u5f85\u8fd4\u56de\u683c\u5f0f\u6570\u636e\u548c\u5b9e\u9645\u8fd4\u56de\u6570\u636e\u4e0d\u4e00\u81f4\u3002\u8bf7\u8054\u7cfb\u94f6\u884c\u53cd\u9988\u3002", (String)"DetailImpl_9", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
        detail.setTransDate(transDate);
        detail.setTransTime(transTime);
        String DCFlag = JDomUtils.getChildTextNotNull((Element)map, (String)"DCFlag", (String)ResManager.loadKDString((String)"\u501f\u8d37\u6807\u5fd7", (String)"DetailImpl_10", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
        String Amount = JDomUtils.getChildTextNotNull((Element)map, (String)"Amount", (String)ResManager.loadKDString((String)"\u53d1\u751f\u989d", (String)"DetailImpl_11", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
        if ("C".equals(DCFlag)) {
            detail.setCreditAmount(BigDecimalHelper.str2BigDecimal((String)Amount));
            detail.setDebitAmount(BigDecimalHelper.ZERO);
        } else if ("D".equals(DCFlag)) {
            detail.setCreditAmount(BigDecimalHelper.ZERO);
            detail.setDebitAmount(BigDecimalHelper.str2BigDecimal((String)Amount));
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u672a\u77e5\u7684'\u501f\u8d37\u6807\u5fd7':%1$s,\u65e0\u6cd5\u786e\u5b9a\u8be5\u7b14\u4ea4\u6613\u7684\u501f\u8d37\u7c7b\u578b,\u8bf7\u5411\u94f6\u884c\u53cd\u9988\u8be5\u60c5\u51b5.", (String)"DetailImpl_17", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), DCFlag));
        }
        if (!StringUtils.isEmpty((String)Balance)) {
            detail.setBalance(BigDecimalHelper.str2BigDecimal((String)Balance));
        }
        String KD = "KD@";
        if (!StringUtils.isEmpty((String)Remark) && Remark.indexOf(KD) != -1) {
            String bankDetailSeqId = Remark.substring(0, Remark.indexOf(KD));
            DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
            detail.setPayBankDetailSeqID(bankDetailSeqId);
        }
        detail.setExplanation(Remark);
        String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(map);
        String receiptNo = MatchRule.getInstance().getReceiptNo(detail.getAccNo(), TransJnlDate, jsonStr);
        if (countMap.containsKey(receiptNo)) {
            int count = countMap.get(receiptNo) + 1;
            countMap.put(receiptNo, count);
            receiptNo = receiptNo + "-" + String.format("%04d", count);
        } else {
            countMap.put(receiptNo, 0);
        }
        detail.setJsonMap(jsonStr);
        detail.setBankDetailNo(JDomUtils.getChildText((Element)map, (String)"TransJnlNo"));
        detail.setOppAccNo(PayeeAcNo);
        detail.setOppAccName(PayeeAcName);
        detail.setOppBankName(PayeeAcBankName);
        detail.setReceiptNo(receiptNo);
        return detail;
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "B2EActTrsQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_14", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/xml");
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/").append("B2EActTrsQry").append(".do?");
        sb.append("userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"userPassword"));
        sb.append("&SIGDATA=1");
        factory.setUri(sb.toString());
    }
}

