/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sde.dc.services.payment.inner;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sde.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.sde.dc.services.payment.inner.InnerQueryPayImpl;
import kd.ebg.aqap.banks.sde.dc.utils.SDEPackerUtils;
import kd.ebg.aqap.banks.sde.dc.utils.SDEParserUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class InnerPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InnerQueryPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = SDEPackerUtils.createRootWithHead(Sequence.genSequence(), "B2EBankInnerTransfer");
        Element Body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)Body, (String)"SubmitNo", (String)paymentInfo.getBankDetailSeqId());
        Element List2 = JDomUtils.addChild((Element)Body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)Map2, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)Map2, (String)"TrsPassword", (String)RequestContextUtils.getParameter().getBankParameter("userPassword"));
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)Map2, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)Map2, (String)"Amount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)Map2, (String)"PayerCurrency", (String)paymentInfo.getCurrency());
        String exp = paymentInfo.getExplanation();
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            exp = paymentInfo.getBankDetailSeqId() + "KD@" + paymentInfo.getExplanation();
        }
        JDomUtils.addChild((Element)Map2, (String)"Remark", (String)exp);
        return JDomUtils.root2String((Element)root, (String)"GBK");
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        try {
            Element root = SDEParserUtils.parseRspToRoot(responseStr);
            BankResponse response = SDEParserUtils.parseResponse(root);
            if (!"000000".equalsIgnoreCase(response.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u7aef\u652f\u4ed8\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (String)"InnerPayImpl_0", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            } else {
                Element Body = JDomUtils.getChildElementNotNull((Element)root, (String)"Body");
                Element List2 = JDomUtils.getChildElementNotNull((Element)Body, (String)"List");
                Element Map2 = JDomUtils.getChildElementNotNull((Element)List2, (String)"Map");
                String ReturnCode = JDomUtils.getChildTextNotNull((Element)Map2, (String)"ReturnCode", (String)ResManager.loadKDString((String)"\u8fd4\u56de\u72b6\u6001\u7801", (String)"InnerPayImpl_1", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]));
                String ReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Map2, (String)"ReturnMsg");
                if (!"000000".equalsIgnoreCase(ReturnCode)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u7aef\u652f\u4ed8\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (String)"InnerPayImpl_0", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                } else {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)response.getResponseMessage());
                }
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u8fd4\u56de\u6570\u636e\u5f02\u5e38:%1$s\u3002", (String)"InnerPayImpl_4", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "B2EBankInnerTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"InnerPayImpl_3", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.is2SameBank();
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/xml");
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/").append("B2EBankInnerTransfer").append(".do?");
        sb.append("userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"userPassword"));
        sb.append("&SIGDATA=1");
        factory.setUri(sb.toString());
    }
}

