/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.payment.individual.salary;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nbcb.dc.service.DomHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.EBBizType;
import kd.ebg.aqap.banks.nbcb.dc.service.NBCBEBankDataHelper;
import kd.ebg.aqap.banks.nbcb.dc.service.ResponseCheck;
import kd.ebg.aqap.banks.nbcb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;

public class InnerAndOuterResultQuery
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(InnerAndOuterResultQuery.class);

    public EBBankPayResponse queryPay(BankPayRequest request) {
        return this.doBiz(request);
    }

    public int getBatchSize() {
        return 200;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "srv245_innerAndOuterResultQuery";
    }

    public String getBizDesc() {
        return "";
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element NBCBEBankData = new Element("NBCBEBankData");
        NBCBEBankDataHelper.add(NBCBEBankData, LoginAndOut.getLoginAndOut().loginSessionId4Query(), this.getBizCode(), EBBizType.QUERY_PAY_STATUS);
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)NBCBEBankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        JDomUtils.addChild((Element)ReqParam, (String)"KHLS", (String)paymentInfo.getBankBatchSeqId());
        String signData = "null";
        JDomUtils.addChild((Element)NBCBEBankData, (String)"signData", (String)signData);
        return DomHelper.doc2StringPlain(new Document(NBCBEBankData), RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        Element NBCBEBankData;
        List paymentInfos = request.getPaymentInfos();
        String bankBatchSeqID = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID();
        try {
            NBCBEBankData = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            ResponseCheck.checkResponse(NBCBEBankData, ResManager.loadKDString((String)"\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\u5f02\u5e38:%1$s\u3002", (String)"QueryPayParser_17", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        try {
            Element opRep = DomHelper.getChildElementNotNull(NBCBEBankData, "opRep");
            Element opResult = DomHelper.getChildElementNotNull(opRep, "opResult");
            String YDDM = DomHelper.getChildTextNotNull(opResult, "YDDM", ResManager.loadKDString((String)"\u4ea4\u6613\u5e94\u7b54\u4ee3\u7801", (String)"QueryPayParser_3", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
            String SBYY = DomHelper.getChildTextNullAsBlank(opResult, "SBYY");
            Element list = DomHelper.getChildElementNotNull(opResult, "list");
            List rows = list.getChildren("row");
            for (Element row : rows) {
                String JYZT = DomHelper.getChildTextNotNull(row, "JYZT");
                String MXLS = DomHelper.getChildTextNotNull(row, "MXLS");
                PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)bankBatchSeqID, (String)MXLS);
                if (paymentInfo == null) {
                    logger.info("\u8df3\u8fc7{}", (Object)MXLS);
                    continue;
                }
                if ("90".equals(JYZT)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)JYZT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_7", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]));
                    continue;
                }
                if ("91".equals(JYZT)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)JYZT, (String)SBYY);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u94f6\u4f01\u672a\u80fd\u7406\u89e3\u7684\u4ea4\u6613\u72b6\u6001\u7801:%1$s,\u8bf7\u5411\u94f6\u884c\u53cd\u9988", (String)"QueryPayParser_18", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), JYZT), (String)JYZT, (String)SBYY);
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2\u54cd\u5e94\u62a5\u6587\u5f02\u5e38:%1$s\u3002", (String)"QueryPayParser_19", (String)"ebg-aqap-banks-nbcb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        NBCBEBankDataHelper.configConnection(factory);
    }
}

