/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.xtb.dc.utils.GLBParser;
import kd.ebg.aqap.banks.xtb.dc.utils.IOUtils;
import kd.ebg.aqap.banks.xtb.dc.utils.TCommon;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CashPoolDetailParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CashPoolDetailParser.class);

    public List<DetailInfo> parseCashPoolDetail(BankDetailRequest rqst, String rspStr) {
        return this.parseCPDetail(rqst, rspStr);
    }

    private List<DetailInfo> parseCPDetail(BankDetailRequest rqst, String rspStr) {
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)TCommon.parseRecvMsg(rspStr), (String)encoding);
        Element head = ebenk.getChild("head");
        String retcode = head.getChildText("ret_code");
        String succ_flag = head.getChildText("succ_flag");
        if ("0000".equalsIgnoreCase(retcode) && "0".equalsIgnoreCase(succ_flag)) {
            Element body = ebenk.getChild("body");
            String record_num = body.getChildTextTrim("record_num");
            String field_num = body.getChildTextTrim("field_num");
            int recordNum = -1;
            if (!StringUtils.isEmpty((String)record_num)) {
                recordNum = Integer.parseInt(record_num);
            }
            int fieldNum = -1;
            if (!StringUtils.isEmpty((String)field_num)) {
                fieldNum = Integer.parseInt(field_num);
            }
            String content = null;
            if (recordNum <= 0) {
                return details;
            }
            if ("0".equals(head.getChildTextTrim("file_flag"))) {
                String serial_record;
                logger.info("\u8fd4\u56de\u7684\u662f\u62a5\u6587\uff0c\u4eceserial_record\u91cc\u9762\u62ff\u5230\u4fe1\u606f");
                content = serial_record = body.getChildTextTrim("serial_record");
            } else if ("1".equals(head.getChildTextTrim("file_flag"))) {
                logger.info("\u8fd4\u56de\u7684\u662f\u6587\u4ef6");
                String file_name = body.getChildTextTrim("file_name");
                content = IOUtils.downloadFileFromLocal(file_name);
            }
            String[][] rs = GLBParser.parseMFS(content, recordNum, fieldNum);
            for (int k = 0; k < rs.length; ++k) {
                String[] rs_k = rs[k];
                DetailInfo detailInfo = this.parseRecord(rs_k);
                details.add(detailInfo);
            }
            logger.info("===\u89e3\u6790<\u5f52\u96c6\u8d26\u6237\u4f59\u989d\u67e5\u8be2>\u62a5\u6587\u7ed3\u675f===");
            return details;
        }
        String ret_info = head.getChildText("ret_info");
        String ext_info = head.getChildText("ext_info");
        String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u96c6\u8d26\u6237\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\uff0c\u9644\u52a0\u5f02\u5e38\u4fe1\u606f%3$s\u3002", (String)"CashPoolDetailParser_3", (String)"ebg-aqap-banks-xtb-dc", (Object[])new Object[0]), retcode, ret_info, ext_info);
        logger.error(resMsg);
        throw EBExceiptionUtil.serviceException((String)resMsg);
    }

    private DetailInfo parseRecord(String[] r2_k) {
        DetailInfo detailInfo = new DetailInfo();
        String cur_code = r2_k[2];
        detailInfo.setCurrency(cur_code);
        String oppacno = r2_k[22];
        detailInfo.setOppAccNo(oppacno);
        String oppacname = r2_k[24];
        detailInfo.setOppAccName(oppacname);
        String accountOpenNode = r2_k[25];
        detailInfo.setOppAccName(accountOpenNode);
        String acno = r2_k[1];
        detailInfo.setAccNo(acno);
        String acname = r2_k[45];
        detailInfo.setAccName(acname);
        String transferDate = r2_k[6];
        Date transTime = GLBParser.parseGLBTransTime(transferDate);
        Date now = new Date();
        if (transTime.after(now)) {
            detailInfo.setTransTime(LocalDateUtil.date2LocalDateTime((Date)now));
        } else {
            detailInfo.setTransTime(LocalDateUtil.date2LocalDateTime((Date)transTime));
        }
        detailInfo.setTransDate(detailInfo.getTransTime().toLocalDate());
        String payAmount = r2_k[49];
        String recAmount = r2_k[50];
        String CDFlag = r2_k[13];
        BigDecimal payAmountD = new BigDecimal(payAmount);
        BigDecimal recAmountD = new BigDecimal(recAmount);
        if (CDFlag.equalsIgnoreCase("D")) {
            detailInfo.setDebitAmount(payAmountD);
            detailInfo.setCreditAmount(new BigDecimal(0));
        } else if (CDFlag.equalsIgnoreCase("C")) {
            detailInfo.setDebitAmount(new BigDecimal(0));
            detailInfo.setCreditAmount(recAmountD);
        } else {
            detailInfo.setDebitAmount(payAmountD);
            detailInfo.setCreditAmount(recAmountD);
        }
        String AcctBal = r2_k[16];
        BigDecimal balance = new BigDecimal(AcctBal);
        detailInfo.setBalance(balance);
        String summary = StringUtils.isNotEmpty((String)r2_k[32]) ? r2_k[32] : r2_k[33];
        detailInfo.setExplanation(summary);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tr_acdt", (Object)r2_k[6]);
        jsonObject.put("host_serial_no", (Object)r2_k[5]);
        jsonObject.put("crdr_flag", (Object)CDFlag);
        jsonObject.put("amt", (Object)r2_k[14]);
        detailInfo.setJsonMap(jsonObject.toJSONString());
        detailInfo.setBankDetailNo(r2_k[5]);
        return detailInfo;
    }
}

