/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.ca.util;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class GenerateCACertificate {
    private String subjectCN;
    private String keyPairAlgorithm;
    private String signAlgorithm;
    private Date notBeforeDate;
    private Date notAfterDate;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public void initKey() throws NoSuchAlgorithmException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.getKeyPairAlgorithm());
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.setPrivateKey(keyPair.getPrivate());
        this.setPublicKey(keyPair.getPublic());
    }

    public X509Certificate generateCACert() throws Exception {
        X500Name issuerName;
        X500Name subjectName = issuerName = new X500Name(this.getSubjectCN());
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuerName, serialNumber, this.getNotBeforeDate(), this.getNotAfterDate(), subjectName, this.getPublicKey());
        certBuilder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        certBuilder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(6));
        ContentSigner signer = new JcaContentSignerBuilder(this.getSignAlgorithm()).build(this.getPrivateKey());
        X509Certificate certificate = new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(certBuilder.build(signer));
        return certificate;
    }

    public String getSubjectCN() {
        return this.subjectCN;
    }

    public void setSubjectCN(String subjectCN) {
        this.subjectCN = subjectCN;
    }

    public String getKeyPairAlgorithm() {
        return this.keyPairAlgorithm;
    }

    public void setKeyPairAlgorithm(String keyPairAlgorithm) {
        this.keyPairAlgorithm = keyPairAlgorithm;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    public Date getNotBeforeDate() {
        return this.notBeforeDate;
    }

    public void setNotBeforeDate(Date notBeforeDate) {
        this.notBeforeDate = notBeforeDate;
    }

    public Date getNotAfterDate() {
        return this.notAfterDate;
    }

    public void setNotAfterDate(Date notAfterDate) {
        this.notAfterDate = notAfterDate;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }
}

