/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.banklogin;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.model.monitor.LoginMonitorStatisticInfo;
import kd.ebg.egf.common.repository.monitor.BankReqRecordRepository;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class BankLoginBusyMonitorChart
extends AbstractFormPlugin {
    private static final List<String> TYPES = Arrays.asList("0", "20", "40", "60", "80", "100", "120");
    private BankReqRecordRepository bankReqRecordRepository = (BankReqRecordRepository)SpringContextUtil.getBean(BankReqRecordRepository.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        PointLineChart pointLineChart = (PointLineChart)this.getControl("pointlinechartap");
        this.drawChart(pointLineChart);
    }

    private void drawChart(PointLineChart pointLineChart) {
        Axis categoryAxis = pointLineChart.createXAxis(ResManager.loadKDString((String)"\u65f6\u95f4", (String)"BankLoginBusyMonitorChart_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), AxisType.category);
        ArrayList<String> categories = new ArrayList<String>(24);
        categories.add("00.00");
        categories.add("01.00");
        categories.add("02.00");
        categories.add("03.00");
        categories.add("04.00");
        categories.add("05.00");
        categories.add("06.00");
        categories.add("07.00");
        categories.add("08.00");
        categories.add("09.00");
        categories.add("10.00");
        categories.add("11.00");
        categories.add("12.00");
        categories.add("13.00");
        categories.add("14.00");
        categories.add("15.00");
        categories.add("16.00");
        categories.add("17.00");
        categories.add("18.00");
        categories.add("19.00");
        categories.add("20.00");
        categories.add("21.00");
        categories.add("22.00");
        categories.add("23.00");
        categories.add("24.00");
        categoryAxis.setCategorys(categories);
        HashMap nametextstyle = Maps.newHashMap();
        nametextstyle.put("color", "#000000");
        nametextstyle.put("fontSize", 16);
        categoryAxis.setPropValue("nameTextStyle", (Object)nametextstyle);
        categoryAxis.setPropValue("nameLocation", (Object)"end");
        categoryAxis.setPropValue("position", (Object)"bottom");
        HashMap axislabel = Maps.newHashMap();
        HashMap textstyle = Maps.newHashMap();
        textstyle.put("color", "#000000");
        textstyle.put("fontSize", "16");
        axislabel.put("textStyle", textstyle);
        categoryAxis.setPropValue("axisLabel", (Object)axislabel);
        Axis yAxis = pointLineChart.createYAxis("%", AxisType.value);
        HashMap axisTick = Maps.newHashMap();
        axisTick.put("show", Boolean.TRUE);
        yAxis.setPropValue("axisTick", (Object)axisTick);
        yAxis.setCategorys(TYPES);
        HashMap nametextstyle1 = Maps.newHashMap();
        HashMap lineStyle = Maps.newHashMap();
        nametextstyle1.put("color", "#000000");
        nametextstyle1.put("fontSize", 16);
        yAxis.setPropValue("nameTextStyle", (Object)nametextstyle1);
        HashMap splitLine = Maps.newHashMap();
        HashMap axislabel1 = Maps.newHashMap();
        HashMap textstyle1 = Maps.newHashMap();
        textstyle.put("color", "#000000");
        textstyle.put("fontSize", "16");
        axislabel.put("textStyle", textstyle1);
        yAxis.setPropValue("axisLabel", (Object)axislabel1);
        lineStyle.put("color", "#003A3D");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", (Object)splitLine);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        LocalDateTime startTime = LocalDateTime.parse(paramMap.get("startDateTime").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        LocalDateTime endTime = LocalDateTime.parse(paramMap.get("endDateTime").toString(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String customID = RequestContext.get().getTenantId();
        Map infoMap = this.bankReqRecordRepository.getStatisticMapByCustomID(customID, startTime, endTime);
        String bankLoginName = paramMap.get("bankLoginName").toString();
        HashMap details = new HashMap(16);
        String id = "";
        String date = startTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        for (Map.Entry m : infoMap.entrySet()) {
            if (!((String)m.getKey()).equalsIgnoreCase(bankLoginName)) continue;
            id = (String)m.getKey();
            List list = ((List)m.getValue()).stream().filter(a -> a.getTimeSlot().startsWith(date)).collect(Collectors.toList());
            details.put(m.getKey(), list);
        }
        Number[] blockRate = new Number[24];
        Number[] processRate = new Number[24];
        List data = (List)details.get(id);
        for (int i = 0; i < data.size(); ++i) {
            blockRate[i] = ((LoginMonitorStatisticInfo)data.get(i)).getBlockRate();
            processRate[i] = ((LoginMonitorStatisticInfo)data.get(i)).getProcessRate();
        }
        this.createLine(pointLineChart, ResManager.loadKDString((String)"\u963b\u585e\u9891\u7387", (String)"BankLoginBusyMonitorChart_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), blockRate, "#FB2323");
        this.createLine(pointLineChart, ResManager.loadKDString((String)"\u5229\u7528\u7387", (String)"BankLoginBusyMonitorChart_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), processRate, "#1BA854");
        pointLineChart.setMargin(Position.right, "80px");
        pointLineChart.setMargin(Position.left, "80px");
        pointLineChart.setLegendPropValue("top", (Object)"8%");
        pointLineChart.refresh();
    }

    private void createLine(PointLineChart pointLineChart, String name, Number[] data, String color) {
        LineSeries expireSeries = pointLineChart.createSeries(name);
        expireSeries.setData(data);
        expireSeries.setItemColor(color);
        Label label = new Label();
        label.setShow(true);
        label.setColor("#FFFFFF");
        expireSeries.setLabel(label);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        kd.bos.form.control.Label label = (kd.bos.form.control.Label)this.getView().getControl("labelap1");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String bankLoginName = paramMap.get("bankLoginName").toString();
        label.setText(bankLoginName);
        Date s = DateUtil.string2Date((String)paramMap.get("startDateTime").toString(), (String)"yyyy-MM-dd HH:mm:ss");
        String startTime = DateUtil.formatDate((Date)s, (String)"yyyy-MM-dd");
        kd.bos.form.control.Label label1 = (kd.bos.form.control.Label)this.getView().getControl("labelap11");
        label1.setText(startTime);
    }
}

